/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lookoutmetrics.model.AlertSummary;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class AlertSummaryMarshaller {
    private static final MarshallingInfo<String> ALERTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlertArn").build();
    private static final MarshallingInfo<String> ANOMALYDETECTORARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnomalyDetectorArn").build();
    private static final MarshallingInfo<String> ALERTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlertName").build();
    private static final MarshallingInfo<Integer> ALERTSENSITIVITYTHRESHOLD_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlertSensitivityThreshold").build();
    private static final MarshallingInfo<String> ALERTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlertType").build();
    private static final MarshallingInfo<String> ALERTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlertStatus").build();
    private static final MarshallingInfo<Date> LASTMODIFICATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModificationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final AlertSummaryMarshaller instance = new AlertSummaryMarshaller();

    public static AlertSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(AlertSummary alertSummary, ProtocolMarshaller protocolMarshaller) {
        if (alertSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(alertSummary.getAlertArn(), ALERTARN_BINDING);
            protocolMarshaller.marshall(alertSummary.getAnomalyDetectorArn(), ANOMALYDETECTORARN_BINDING);
            protocolMarshaller.marshall(alertSummary.getAlertName(), ALERTNAME_BINDING);
            protocolMarshaller.marshall(alertSummary.getAlertSensitivityThreshold(), ALERTSENSITIVITYTHRESHOLD_BINDING);
            protocolMarshaller.marshall(alertSummary.getAlertType(), ALERTTYPE_BINDING);
            protocolMarshaller.marshall(alertSummary.getAlertStatus(), ALERTSTATUS_BINDING);
            protocolMarshaller.marshall(alertSummary.getLastModificationTime(), LASTMODIFICATIONTIME_BINDING);
            protocolMarshaller.marshall(alertSummary.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(alertSummary.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

