/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lookoutmetrics.model.Frequency;
import com.amazonaws.services.lookoutmetrics.model.Metric;
import com.amazonaws.services.lookoutmetrics.model.MetricSource;
import com.amazonaws.services.lookoutmetrics.model.TimestampColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateMetricSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String anomalyDetectorArn;
    private String metricSetName;
    private String metricSetDescription;
    private List<Metric> metricList;
    private Integer offset;
    private TimestampColumn timestampColumn;
    private List<String> dimensionList;
    private String metricSetFrequency;
    private MetricSource metricSource;
    private String timezone;
    private Map<String, String> tags;

    public void setAnomalyDetectorArn(String anomalyDetectorArn) {
        this.anomalyDetectorArn = anomalyDetectorArn;
    }

    public String getAnomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public CreateMetricSetRequest withAnomalyDetectorArn(String anomalyDetectorArn) {
        this.setAnomalyDetectorArn(anomalyDetectorArn);
        return this;
    }

    public void setMetricSetName(String metricSetName) {
        this.metricSetName = metricSetName;
    }

    public String getMetricSetName() {
        return this.metricSetName;
    }

    public CreateMetricSetRequest withMetricSetName(String metricSetName) {
        this.setMetricSetName(metricSetName);
        return this;
    }

    public void setMetricSetDescription(String metricSetDescription) {
        this.metricSetDescription = metricSetDescription;
    }

    public String getMetricSetDescription() {
        return this.metricSetDescription;
    }

    public CreateMetricSetRequest withMetricSetDescription(String metricSetDescription) {
        this.setMetricSetDescription(metricSetDescription);
        return this;
    }

    public List<Metric> getMetricList() {
        return this.metricList;
    }

    public void setMetricList(Collection<Metric> metricList) {
        if (metricList == null) {
            this.metricList = null;
            return;
        }
        this.metricList = new ArrayList<Metric>(metricList);
    }

    public CreateMetricSetRequest withMetricList(Metric ... metricList) {
        if (this.metricList == null) {
            this.setMetricList(new ArrayList<Metric>(metricList.length));
        }
        for (Metric ele : metricList) {
            this.metricList.add(ele);
        }
        return this;
    }

    public CreateMetricSetRequest withMetricList(Collection<Metric> metricList) {
        this.setMetricList(metricList);
        return this;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public CreateMetricSetRequest withOffset(Integer offset) {
        this.setOffset(offset);
        return this;
    }

    public void setTimestampColumn(TimestampColumn timestampColumn) {
        this.timestampColumn = timestampColumn;
    }

    public TimestampColumn getTimestampColumn() {
        return this.timestampColumn;
    }

    public CreateMetricSetRequest withTimestampColumn(TimestampColumn timestampColumn) {
        this.setTimestampColumn(timestampColumn);
        return this;
    }

    public List<String> getDimensionList() {
        return this.dimensionList;
    }

    public void setDimensionList(Collection<String> dimensionList) {
        if (dimensionList == null) {
            this.dimensionList = null;
            return;
        }
        this.dimensionList = new ArrayList<String>(dimensionList);
    }

    public CreateMetricSetRequest withDimensionList(String ... dimensionList) {
        if (this.dimensionList == null) {
            this.setDimensionList(new ArrayList<String>(dimensionList.length));
        }
        for (String ele : dimensionList) {
            this.dimensionList.add(ele);
        }
        return this;
    }

    public CreateMetricSetRequest withDimensionList(Collection<String> dimensionList) {
        this.setDimensionList(dimensionList);
        return this;
    }

    public void setMetricSetFrequency(String metricSetFrequency) {
        this.metricSetFrequency = metricSetFrequency;
    }

    public String getMetricSetFrequency() {
        return this.metricSetFrequency;
    }

    public CreateMetricSetRequest withMetricSetFrequency(String metricSetFrequency) {
        this.setMetricSetFrequency(metricSetFrequency);
        return this;
    }

    public CreateMetricSetRequest withMetricSetFrequency(Frequency metricSetFrequency) {
        this.metricSetFrequency = metricSetFrequency.toString();
        return this;
    }

    public void setMetricSource(MetricSource metricSource) {
        this.metricSource = metricSource;
    }

    public MetricSource getMetricSource() {
        return this.metricSource;
    }

    public CreateMetricSetRequest withMetricSource(MetricSource metricSource) {
        this.setMetricSource(metricSource);
        return this;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public CreateMetricSetRequest withTimezone(String timezone) {
        this.setTimezone(timezone);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateMetricSetRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateMetricSetRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateMetricSetRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnomalyDetectorArn() != null) {
            sb.append("AnomalyDetectorArn: ").append(this.getAnomalyDetectorArn()).append(",");
        }
        if (this.getMetricSetName() != null) {
            sb.append("MetricSetName: ").append(this.getMetricSetName()).append(",");
        }
        if (this.getMetricSetDescription() != null) {
            sb.append("MetricSetDescription: ").append(this.getMetricSetDescription()).append(",");
        }
        if (this.getMetricList() != null) {
            sb.append("MetricList: ").append(this.getMetricList()).append(",");
        }
        if (this.getOffset() != null) {
            sb.append("Offset: ").append(this.getOffset()).append(",");
        }
        if (this.getTimestampColumn() != null) {
            sb.append("TimestampColumn: ").append(this.getTimestampColumn()).append(",");
        }
        if (this.getDimensionList() != null) {
            sb.append("DimensionList: ").append(this.getDimensionList()).append(",");
        }
        if (this.getMetricSetFrequency() != null) {
            sb.append("MetricSetFrequency: ").append(this.getMetricSetFrequency()).append(",");
        }
        if (this.getMetricSource() != null) {
            sb.append("MetricSource: ").append(this.getMetricSource()).append(",");
        }
        if (this.getTimezone() != null) {
            sb.append("Timezone: ").append(this.getTimezone()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetricSetRequest)) {
            return false;
        }
        CreateMetricSetRequest other = (CreateMetricSetRequest)obj;
        if (other.getAnomalyDetectorArn() == null ^ this.getAnomalyDetectorArn() == null) {
            return false;
        }
        if (other.getAnomalyDetectorArn() != null && !other.getAnomalyDetectorArn().equals(this.getAnomalyDetectorArn())) {
            return false;
        }
        if (other.getMetricSetName() == null ^ this.getMetricSetName() == null) {
            return false;
        }
        if (other.getMetricSetName() != null && !other.getMetricSetName().equals(this.getMetricSetName())) {
            return false;
        }
        if (other.getMetricSetDescription() == null ^ this.getMetricSetDescription() == null) {
            return false;
        }
        if (other.getMetricSetDescription() != null && !other.getMetricSetDescription().equals(this.getMetricSetDescription())) {
            return false;
        }
        if (other.getMetricList() == null ^ this.getMetricList() == null) {
            return false;
        }
        if (other.getMetricList() != null && !other.getMetricList().equals(this.getMetricList())) {
            return false;
        }
        if (other.getOffset() == null ^ this.getOffset() == null) {
            return false;
        }
        if (other.getOffset() != null && !other.getOffset().equals(this.getOffset())) {
            return false;
        }
        if (other.getTimestampColumn() == null ^ this.getTimestampColumn() == null) {
            return false;
        }
        if (other.getTimestampColumn() != null && !other.getTimestampColumn().equals(this.getTimestampColumn())) {
            return false;
        }
        if (other.getDimensionList() == null ^ this.getDimensionList() == null) {
            return false;
        }
        if (other.getDimensionList() != null && !other.getDimensionList().equals(this.getDimensionList())) {
            return false;
        }
        if (other.getMetricSetFrequency() == null ^ this.getMetricSetFrequency() == null) {
            return false;
        }
        if (other.getMetricSetFrequency() != null && !other.getMetricSetFrequency().equals(this.getMetricSetFrequency())) {
            return false;
        }
        if (other.getMetricSource() == null ^ this.getMetricSource() == null) {
            return false;
        }
        if (other.getMetricSource() != null && !other.getMetricSource().equals(this.getMetricSource())) {
            return false;
        }
        if (other.getTimezone() == null ^ this.getTimezone() == null) {
            return false;
        }
        if (other.getTimezone() != null && !other.getTimezone().equals(this.getTimezone())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnomalyDetectorArn() == null ? 0 : this.getAnomalyDetectorArn().hashCode());
        hashCode = 31 * hashCode + (this.getMetricSetName() == null ? 0 : this.getMetricSetName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricSetDescription() == null ? 0 : this.getMetricSetDescription().hashCode());
        hashCode = 31 * hashCode + (this.getMetricList() == null ? 0 : this.getMetricList().hashCode());
        hashCode = 31 * hashCode + (this.getOffset() == null ? 0 : this.getOffset().hashCode());
        hashCode = 31 * hashCode + (this.getTimestampColumn() == null ? 0 : this.getTimestampColumn().hashCode());
        hashCode = 31 * hashCode + (this.getDimensionList() == null ? 0 : this.getDimensionList().hashCode());
        hashCode = 31 * hashCode + (this.getMetricSetFrequency() == null ? 0 : this.getMetricSetFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getMetricSource() == null ? 0 : this.getMetricSource().hashCode());
        hashCode = 31 * hashCode + (this.getTimezone() == null ? 0 : this.getTimezone().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateMetricSetRequest clone() {
        return (CreateMetricSetRequest)super.clone();
    }
}

