/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutequipment;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lookoutequipment.AmazonLookoutEquipment;
import com.amazonaws.services.lookoutequipment.AmazonLookoutEquipmentClientBuilder;
import com.amazonaws.services.lookoutequipment.model.AmazonLookoutEquipmentException;
import com.amazonaws.services.lookoutequipment.model.CreateDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.CreateDatasetResult;
import com.amazonaws.services.lookoutequipment.model.CreateInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.CreateInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.CreateModelRequest;
import com.amazonaws.services.lookoutequipment.model.CreateModelResult;
import com.amazonaws.services.lookoutequipment.model.DeleteDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteDatasetResult;
import com.amazonaws.services.lookoutequipment.model.DeleteInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.DeleteModelRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteModelResult;
import com.amazonaws.services.lookoutequipment.model.DescribeDataIngestionJobRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeDataIngestionJobResult;
import com.amazonaws.services.lookoutequipment.model.DescribeDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeDatasetResult;
import com.amazonaws.services.lookoutequipment.model.DescribeInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.DescribeModelRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeModelResult;
import com.amazonaws.services.lookoutequipment.model.ListDataIngestionJobsRequest;
import com.amazonaws.services.lookoutequipment.model.ListDataIngestionJobsResult;
import com.amazonaws.services.lookoutequipment.model.ListDatasetsRequest;
import com.amazonaws.services.lookoutequipment.model.ListDatasetsResult;
import com.amazonaws.services.lookoutequipment.model.ListInferenceExecutionsRequest;
import com.amazonaws.services.lookoutequipment.model.ListInferenceExecutionsResult;
import com.amazonaws.services.lookoutequipment.model.ListInferenceSchedulersRequest;
import com.amazonaws.services.lookoutequipment.model.ListInferenceSchedulersResult;
import com.amazonaws.services.lookoutequipment.model.ListModelsRequest;
import com.amazonaws.services.lookoutequipment.model.ListModelsResult;
import com.amazonaws.services.lookoutequipment.model.ListTagsForResourceRequest;
import com.amazonaws.services.lookoutequipment.model.ListTagsForResourceResult;
import com.amazonaws.services.lookoutequipment.model.StartDataIngestionJobRequest;
import com.amazonaws.services.lookoutequipment.model.StartDataIngestionJobResult;
import com.amazonaws.services.lookoutequipment.model.StartInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.StartInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.StopInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.StopInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.TagResourceRequest;
import com.amazonaws.services.lookoutequipment.model.TagResourceResult;
import com.amazonaws.services.lookoutequipment.model.UntagResourceRequest;
import com.amazonaws.services.lookoutequipment.model.UntagResourceResult;
import com.amazonaws.services.lookoutequipment.model.UpdateInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.UpdateInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateDatasetRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateDatasetResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateModelRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateModelResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteDatasetRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteDatasetResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteModelRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteModelResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeDataIngestionJobRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeDataIngestionJobResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeDatasetRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeDatasetResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeModelRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeModelResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListDataIngestionJobsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListDataIngestionJobsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListDatasetsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListDatasetsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListInferenceExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListInferenceExecutionsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListInferenceSchedulersRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListInferenceSchedulersResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListModelsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListModelsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StartDataIngestionJobRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StartDataIngestionJobResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StartInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StartInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StopInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StopInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.UpdateInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.UpdateInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AmazonLookoutEquipmentClient
extends AmazonWebServiceClient
implements AmazonLookoutEquipment {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonLookoutEquipment.class);
    private static final String DEFAULT_SIGNING_NAME = "lookoutequipment";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller(ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller(ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonLookoutEquipmentException.class));

    public static AmazonLookoutEquipmentClientBuilder builder() {
        return AmazonLookoutEquipmentClientBuilder.standard();
    }

    AmazonLookoutEquipmentClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonLookoutEquipmentClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("lookoutequipment.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/lookoutequipment/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/lookoutequipment/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDatasetResult executeCreateDataset(CreateDatasetRequest createDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDatasetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDatasetResult createDatasetResult = (CreateDatasetResult)response.getAwsResponse();
            return createDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateInferenceSchedulerResult createInferenceScheduler(CreateInferenceSchedulerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateInferenceSchedulerResult executeCreateInferenceScheduler(CreateInferenceSchedulerRequest createInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInferenceSchedulerResult createInferenceSchedulerResult = (CreateInferenceSchedulerResult)response.getAwsResponse();
            return createInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateModelResult executeCreateModel(CreateModelRequest createModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateModelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateModelResult createModelResult = (CreateModelResult)response.getAwsResponse();
            return createModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatasetResult executeDeleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDatasetResult deleteDatasetResult = (DeleteDatasetResult)response.getAwsResponse();
            return deleteDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInferenceSchedulerResult deleteInferenceScheduler(DeleteInferenceSchedulerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInferenceSchedulerResult executeDeleteInferenceScheduler(DeleteInferenceSchedulerRequest deleteInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInferenceSchedulerResult deleteInferenceSchedulerResult = (DeleteInferenceSchedulerResult)response.getAwsResponse();
            return deleteInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteModelResult deleteModel(DeleteModelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteModelResult executeDeleteModel(DeleteModelRequest deleteModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteModelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteModelResult deleteModelResult = (DeleteModelResult)response.getAwsResponse();
            return deleteModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDataIngestionJobResult describeDataIngestionJob(DescribeDataIngestionJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeDataIngestionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDataIngestionJobResult executeDescribeDataIngestionJob(DescribeDataIngestionJobRequest describeDataIngestionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDataIngestionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDataIngestionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDataIngestionJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeDataIngestionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeDataIngestionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeDataIngestionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDataIngestionJobResult describeDataIngestionJobResult = (DescribeDataIngestionJobResult)response.getAwsResponse();
            return describeDataIngestionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDatasetResult executeDescribeDataset(DescribeDatasetRequest describeDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatasetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDatasetResult describeDatasetResult = (DescribeDatasetResult)response.getAwsResponse();
            return describeDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInferenceSchedulerResult describeInferenceScheduler(DescribeInferenceSchedulerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInferenceSchedulerResult executeDescribeInferenceScheduler(DescribeInferenceSchedulerRequest describeInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInferenceSchedulerResult describeInferenceSchedulerResult = (DescribeInferenceSchedulerResult)response.getAwsResponse();
            return describeInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeModelResult describeModel(DescribeModelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeModelResult executeDescribeModel(DescribeModelRequest describeModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeModelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeModelResult describeModelResult = (DescribeModelResult)response.getAwsResponse();
            return describeModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataIngestionJobsResult listDataIngestionJobs(ListDataIngestionJobsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDataIngestionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataIngestionJobsResult executeListDataIngestionJobs(ListDataIngestionJobsRequest listDataIngestionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataIngestionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataIngestionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataIngestionJobsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listDataIngestionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListDataIngestionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListDataIngestionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataIngestionJobsResult listDataIngestionJobsResult = (ListDataIngestionJobsResult)response.getAwsResponse();
            return listDataIngestionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDatasets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatasetsResult executeListDatasets(ListDatasetsRequest listDatasetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatasetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatasetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatasetsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listDatasetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListDatasets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListDatasetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDatasetsResult listDatasetsResult = (ListDatasetsResult)response.getAwsResponse();
            return listDatasetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInferenceExecutionsResult listInferenceExecutions(ListInferenceExecutionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListInferenceExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInferenceExecutionsResult executeListInferenceExecutions(ListInferenceExecutionsRequest listInferenceExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInferenceExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInferenceExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInferenceExecutionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listInferenceExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListInferenceExecutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListInferenceExecutionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInferenceExecutionsResult listInferenceExecutionsResult = (ListInferenceExecutionsResult)response.getAwsResponse();
            return listInferenceExecutionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInferenceSchedulersResult listInferenceSchedulers(ListInferenceSchedulersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListInferenceSchedulers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInferenceSchedulersResult executeListInferenceSchedulers(ListInferenceSchedulersRequest listInferenceSchedulersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInferenceSchedulersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInferenceSchedulersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInferenceSchedulersRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listInferenceSchedulersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListInferenceSchedulers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListInferenceSchedulersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInferenceSchedulersResult listInferenceSchedulersResult = (ListInferenceSchedulersResult)response.getAwsResponse();
            return listInferenceSchedulersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListModelsResult listModels(ListModelsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListModelsResult executeListModels(ListModelsRequest listModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListModelsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListModelsResult listModelsResult = (ListModelsResult)response.getAwsResponse();
            return listModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDataIngestionJobResult startDataIngestionJob(StartDataIngestionJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartDataIngestionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDataIngestionJobResult executeStartDataIngestionJob(StartDataIngestionJobRequest startDataIngestionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDataIngestionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDataIngestionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDataIngestionJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startDataIngestionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartDataIngestionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartDataIngestionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDataIngestionJobResult startDataIngestionJobResult = (StartDataIngestionJobResult)response.getAwsResponse();
            return startDataIngestionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartInferenceSchedulerResult startInferenceScheduler(StartInferenceSchedulerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartInferenceSchedulerResult executeStartInferenceScheduler(StartInferenceSchedulerRequest startInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartInferenceSchedulerResult startInferenceSchedulerResult = (StartInferenceSchedulerResult)response.getAwsResponse();
            return startInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopInferenceSchedulerResult stopInferenceScheduler(StopInferenceSchedulerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStopInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopInferenceSchedulerResult executeStopInferenceScheduler(StopInferenceSchedulerRequest stopInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(stopInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StopInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopInferenceSchedulerResult stopInferenceSchedulerResult = (StopInferenceSchedulerResult)response.getAwsResponse();
            return stopInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInferenceSchedulerResult updateInferenceScheduler(UpdateInferenceSchedulerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInferenceSchedulerResult executeUpdateInferenceScheduler(UpdateInferenceSchedulerRequest updateInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInferenceSchedulerResult updateInferenceSchedulerResult = (UpdateInferenceSchedulerResult)response.getAwsResponse();
            return updateInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

