/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.location.model.MapConfiguration;

@SdkInternalApi
public class MapConfigurationMarshaller {
    private static final MarshallingInfo<String> STYLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Style").build();
    private static final MapConfigurationMarshaller instance = new MapConfigurationMarshaller();

    public static MapConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MapConfiguration mapConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (mapConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(mapConfiguration.getStyle(), STYLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

