/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.location.model.LegGeometry;
import java.util.List;

@SdkInternalApi
public class LegGeometryMarshaller {
    private static final MarshallingInfo<List> LINESTRING_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LineString").build();
    private static final LegGeometryMarshaller instance = new LegGeometryMarshaller();

    public static LegGeometryMarshaller getInstance() {
        return instance;
    }

    public void marshall(LegGeometry legGeometry, ProtocolMarshaller protocolMarshaller) {
        if (legGeometry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(legGeometry.getLineString(), LINESTRING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

