/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.location.model.DevicePositionUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchUpdateDevicePositionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String trackerName;
    private List<DevicePositionUpdate> updates;

    public void setTrackerName(String trackerName) {
        this.trackerName = trackerName;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public BatchUpdateDevicePositionRequest withTrackerName(String trackerName) {
        this.setTrackerName(trackerName);
        return this;
    }

    public List<DevicePositionUpdate> getUpdates() {
        return this.updates;
    }

    public void setUpdates(Collection<DevicePositionUpdate> updates) {
        if (updates == null) {
            this.updates = null;
            return;
        }
        this.updates = new ArrayList<DevicePositionUpdate>(updates);
    }

    public BatchUpdateDevicePositionRequest withUpdates(DevicePositionUpdate ... updates) {
        if (this.updates == null) {
            this.setUpdates(new ArrayList<DevicePositionUpdate>(updates.length));
        }
        for (DevicePositionUpdate ele : updates) {
            this.updates.add(ele);
        }
        return this;
    }

    public BatchUpdateDevicePositionRequest withUpdates(Collection<DevicePositionUpdate> updates) {
        this.setUpdates(updates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrackerName() != null) {
            sb.append("TrackerName: ").append(this.getTrackerName()).append(",");
        }
        if (this.getUpdates() != null) {
            sb.append("Updates: ").append(this.getUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDevicePositionRequest)) {
            return false;
        }
        BatchUpdateDevicePositionRequest other = (BatchUpdateDevicePositionRequest)obj;
        if (other.getTrackerName() == null ^ this.getTrackerName() == null) {
            return false;
        }
        if (other.getTrackerName() != null && !other.getTrackerName().equals(this.getTrackerName())) {
            return false;
        }
        if (other.getUpdates() == null ^ this.getUpdates() == null) {
            return false;
        }
        return other.getUpdates() == null || other.getUpdates().equals(this.getUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrackerName() == null ? 0 : this.getTrackerName().hashCode());
        hashCode = 31 * hashCode + (this.getUpdates() == null ? 0 : this.getUpdates().hashCode());
        return hashCode;
    }

    @Override
    public BatchUpdateDevicePositionRequest clone() {
        return (BatchUpdateDevicePositionRequest)super.clone();
    }
}

