/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.location.AmazonLocation;
import com.amazonaws.services.location.AmazonLocationClientBuilder;
import com.amazonaws.services.location.model.AmazonLocationException;
import com.amazonaws.services.location.model.AssociateTrackerConsumerRequest;
import com.amazonaws.services.location.model.AssociateTrackerConsumerResult;
import com.amazonaws.services.location.model.BatchDeleteDevicePositionHistoryRequest;
import com.amazonaws.services.location.model.BatchDeleteDevicePositionHistoryResult;
import com.amazonaws.services.location.model.BatchDeleteGeofenceRequest;
import com.amazonaws.services.location.model.BatchDeleteGeofenceResult;
import com.amazonaws.services.location.model.BatchEvaluateGeofencesRequest;
import com.amazonaws.services.location.model.BatchEvaluateGeofencesResult;
import com.amazonaws.services.location.model.BatchGetDevicePositionRequest;
import com.amazonaws.services.location.model.BatchGetDevicePositionResult;
import com.amazonaws.services.location.model.BatchPutGeofenceRequest;
import com.amazonaws.services.location.model.BatchPutGeofenceResult;
import com.amazonaws.services.location.model.BatchUpdateDevicePositionRequest;
import com.amazonaws.services.location.model.BatchUpdateDevicePositionResult;
import com.amazonaws.services.location.model.CalculateRouteRequest;
import com.amazonaws.services.location.model.CalculateRouteResult;
import com.amazonaws.services.location.model.CreateGeofenceCollectionRequest;
import com.amazonaws.services.location.model.CreateGeofenceCollectionResult;
import com.amazonaws.services.location.model.CreateMapRequest;
import com.amazonaws.services.location.model.CreateMapResult;
import com.amazonaws.services.location.model.CreatePlaceIndexRequest;
import com.amazonaws.services.location.model.CreatePlaceIndexResult;
import com.amazonaws.services.location.model.CreateRouteCalculatorRequest;
import com.amazonaws.services.location.model.CreateRouteCalculatorResult;
import com.amazonaws.services.location.model.CreateTrackerRequest;
import com.amazonaws.services.location.model.CreateTrackerResult;
import com.amazonaws.services.location.model.DeleteGeofenceCollectionRequest;
import com.amazonaws.services.location.model.DeleteGeofenceCollectionResult;
import com.amazonaws.services.location.model.DeleteMapRequest;
import com.amazonaws.services.location.model.DeleteMapResult;
import com.amazonaws.services.location.model.DeletePlaceIndexRequest;
import com.amazonaws.services.location.model.DeletePlaceIndexResult;
import com.amazonaws.services.location.model.DeleteRouteCalculatorRequest;
import com.amazonaws.services.location.model.DeleteRouteCalculatorResult;
import com.amazonaws.services.location.model.DeleteTrackerRequest;
import com.amazonaws.services.location.model.DeleteTrackerResult;
import com.amazonaws.services.location.model.DescribeGeofenceCollectionRequest;
import com.amazonaws.services.location.model.DescribeGeofenceCollectionResult;
import com.amazonaws.services.location.model.DescribeMapRequest;
import com.amazonaws.services.location.model.DescribeMapResult;
import com.amazonaws.services.location.model.DescribePlaceIndexRequest;
import com.amazonaws.services.location.model.DescribePlaceIndexResult;
import com.amazonaws.services.location.model.DescribeRouteCalculatorRequest;
import com.amazonaws.services.location.model.DescribeRouteCalculatorResult;
import com.amazonaws.services.location.model.DescribeTrackerRequest;
import com.amazonaws.services.location.model.DescribeTrackerResult;
import com.amazonaws.services.location.model.DisassociateTrackerConsumerRequest;
import com.amazonaws.services.location.model.DisassociateTrackerConsumerResult;
import com.amazonaws.services.location.model.GetDevicePositionHistoryRequest;
import com.amazonaws.services.location.model.GetDevicePositionHistoryResult;
import com.amazonaws.services.location.model.GetDevicePositionRequest;
import com.amazonaws.services.location.model.GetDevicePositionResult;
import com.amazonaws.services.location.model.GetGeofenceRequest;
import com.amazonaws.services.location.model.GetGeofenceResult;
import com.amazonaws.services.location.model.GetMapGlyphsRequest;
import com.amazonaws.services.location.model.GetMapGlyphsResult;
import com.amazonaws.services.location.model.GetMapSpritesRequest;
import com.amazonaws.services.location.model.GetMapSpritesResult;
import com.amazonaws.services.location.model.GetMapStyleDescriptorRequest;
import com.amazonaws.services.location.model.GetMapStyleDescriptorResult;
import com.amazonaws.services.location.model.GetMapTileRequest;
import com.amazonaws.services.location.model.GetMapTileResult;
import com.amazonaws.services.location.model.ListDevicePositionsRequest;
import com.amazonaws.services.location.model.ListDevicePositionsResult;
import com.amazonaws.services.location.model.ListGeofenceCollectionsRequest;
import com.amazonaws.services.location.model.ListGeofenceCollectionsResult;
import com.amazonaws.services.location.model.ListGeofencesRequest;
import com.amazonaws.services.location.model.ListGeofencesResult;
import com.amazonaws.services.location.model.ListMapsRequest;
import com.amazonaws.services.location.model.ListMapsResult;
import com.amazonaws.services.location.model.ListPlaceIndexesRequest;
import com.amazonaws.services.location.model.ListPlaceIndexesResult;
import com.amazonaws.services.location.model.ListRouteCalculatorsRequest;
import com.amazonaws.services.location.model.ListRouteCalculatorsResult;
import com.amazonaws.services.location.model.ListTagsForResourceRequest;
import com.amazonaws.services.location.model.ListTagsForResourceResult;
import com.amazonaws.services.location.model.ListTrackerConsumersRequest;
import com.amazonaws.services.location.model.ListTrackerConsumersResult;
import com.amazonaws.services.location.model.ListTrackersRequest;
import com.amazonaws.services.location.model.ListTrackersResult;
import com.amazonaws.services.location.model.PutGeofenceRequest;
import com.amazonaws.services.location.model.PutGeofenceResult;
import com.amazonaws.services.location.model.SearchPlaceIndexForPositionRequest;
import com.amazonaws.services.location.model.SearchPlaceIndexForPositionResult;
import com.amazonaws.services.location.model.SearchPlaceIndexForTextRequest;
import com.amazonaws.services.location.model.SearchPlaceIndexForTextResult;
import com.amazonaws.services.location.model.TagResourceRequest;
import com.amazonaws.services.location.model.TagResourceResult;
import com.amazonaws.services.location.model.UntagResourceRequest;
import com.amazonaws.services.location.model.UntagResourceResult;
import com.amazonaws.services.location.model.UpdateGeofenceCollectionRequest;
import com.amazonaws.services.location.model.UpdateGeofenceCollectionResult;
import com.amazonaws.services.location.model.UpdateMapRequest;
import com.amazonaws.services.location.model.UpdateMapResult;
import com.amazonaws.services.location.model.UpdatePlaceIndexRequest;
import com.amazonaws.services.location.model.UpdatePlaceIndexResult;
import com.amazonaws.services.location.model.UpdateRouteCalculatorRequest;
import com.amazonaws.services.location.model.UpdateRouteCalculatorResult;
import com.amazonaws.services.location.model.UpdateTrackerRequest;
import com.amazonaws.services.location.model.UpdateTrackerResult;
import com.amazonaws.services.location.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.location.model.transform.AssociateTrackerConsumerRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.AssociateTrackerConsumerResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.BatchDeleteDevicePositionHistoryRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.BatchDeleteDevicePositionHistoryResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.BatchDeleteGeofenceRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.BatchDeleteGeofenceResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.BatchEvaluateGeofencesRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.BatchEvaluateGeofencesResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.BatchGetDevicePositionRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.BatchGetDevicePositionResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.BatchPutGeofenceRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.BatchPutGeofenceResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.BatchUpdateDevicePositionRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.BatchUpdateDevicePositionResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.CalculateRouteRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.CalculateRouteResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.location.model.transform.CreateGeofenceCollectionRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.CreateGeofenceCollectionResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.CreateMapRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.CreateMapResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.CreatePlaceIndexRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.CreatePlaceIndexResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.CreateRouteCalculatorRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.CreateRouteCalculatorResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.CreateTrackerRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.CreateTrackerResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DeleteGeofenceCollectionRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DeleteGeofenceCollectionResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DeleteMapRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DeleteMapResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DeletePlaceIndexRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DeletePlaceIndexResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DeleteRouteCalculatorRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DeleteRouteCalculatorResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DeleteTrackerRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DeleteTrackerResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DescribeGeofenceCollectionRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DescribeGeofenceCollectionResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DescribeMapRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DescribeMapResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DescribePlaceIndexRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DescribePlaceIndexResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DescribeRouteCalculatorRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DescribeRouteCalculatorResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DescribeTrackerRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DescribeTrackerResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.DisassociateTrackerConsumerRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.DisassociateTrackerConsumerResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.GetDevicePositionHistoryRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.GetDevicePositionHistoryResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.GetDevicePositionRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.GetDevicePositionResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.GetGeofenceRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.GetGeofenceResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.GetMapGlyphsRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.GetMapGlyphsResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.GetMapSpritesRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.GetMapSpritesResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.GetMapStyleDescriptorRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.GetMapStyleDescriptorResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.GetMapTileRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.GetMapTileResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.location.model.transform.ListDevicePositionsRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListDevicePositionsResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ListGeofenceCollectionsRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListGeofenceCollectionsResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ListGeofencesRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListGeofencesResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ListMapsRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListMapsResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ListPlaceIndexesRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListPlaceIndexesResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ListRouteCalculatorsRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListRouteCalculatorsResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ListTrackerConsumersRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListTrackerConsumersResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ListTrackersRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.ListTrackersResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.PutGeofenceRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.PutGeofenceResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.location.model.transform.SearchPlaceIndexForPositionRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.SearchPlaceIndexForPositionResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.SearchPlaceIndexForTextRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.SearchPlaceIndexForTextResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.location.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.location.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.UpdateGeofenceCollectionRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.UpdateGeofenceCollectionResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.UpdateMapRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.UpdateMapResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.UpdatePlaceIndexRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.UpdatePlaceIndexResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.UpdateRouteCalculatorRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.UpdateRouteCalculatorResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.UpdateTrackerRequestProtocolMarshaller;
import com.amazonaws.services.location.model.transform.UpdateTrackerResultJsonUnmarshaller;
import com.amazonaws.services.location.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.net.URI;

@ThreadSafe
public class AmazonLocationClient
extends AmazonWebServiceClient
implements AmazonLocation {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonLocation.class);
    private static final String DEFAULT_SIGNING_NAME = "geo";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller(ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller(ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonLocationException.class));

    public static AmazonLocationClientBuilder builder() {
        return AmazonLocationClientBuilder.standard();
    }

    AmazonLocationClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonLocationClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("geo.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/location/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/location/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateTrackerConsumerResult associateTrackerConsumer(AssociateTrackerConsumerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateTrackerConsumer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateTrackerConsumerResult executeAssociateTrackerConsumer(AssociateTrackerConsumerRequest associateTrackerConsumerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateTrackerConsumerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateTrackerConsumerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateTrackerConsumerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateTrackerConsumerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssociateTrackerConsumer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateTrackerConsumerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            AssociateTrackerConsumerResult associateTrackerConsumerResult = (AssociateTrackerConsumerResult)response.getAwsResponse();
            return associateTrackerConsumerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDeleteDevicePositionHistoryResult batchDeleteDevicePositionHistory(BatchDeleteDevicePositionHistoryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchDeleteDevicePositionHistory(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteDevicePositionHistoryResult executeBatchDeleteDevicePositionHistory(BatchDeleteDevicePositionHistoryRequest batchDeleteDevicePositionHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteDevicePositionHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteDevicePositionHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteDevicePositionHistoryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchDeleteDevicePositionHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchDeleteDevicePositionHistory");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchDeleteDevicePositionHistoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            BatchDeleteDevicePositionHistoryResult batchDeleteDevicePositionHistoryResult = (BatchDeleteDevicePositionHistoryResult)response.getAwsResponse();
            return batchDeleteDevicePositionHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDeleteGeofenceResult batchDeleteGeofence(BatchDeleteGeofenceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchDeleteGeofence(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteGeofenceResult executeBatchDeleteGeofence(BatchDeleteGeofenceRequest batchDeleteGeofenceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteGeofenceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteGeofenceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteGeofenceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchDeleteGeofenceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchDeleteGeofence");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchDeleteGeofenceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            BatchDeleteGeofenceResult batchDeleteGeofenceResult = (BatchDeleteGeofenceResult)response.getAwsResponse();
            return batchDeleteGeofenceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchEvaluateGeofencesResult batchEvaluateGeofences(BatchEvaluateGeofencesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchEvaluateGeofences(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchEvaluateGeofencesResult executeBatchEvaluateGeofences(BatchEvaluateGeofencesRequest batchEvaluateGeofencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchEvaluateGeofencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchEvaluateGeofencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchEvaluateGeofencesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchEvaluateGeofencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchEvaluateGeofences");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchEvaluateGeofencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            BatchEvaluateGeofencesResult batchEvaluateGeofencesResult = (BatchEvaluateGeofencesResult)response.getAwsResponse();
            return batchEvaluateGeofencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetDevicePositionResult batchGetDevicePosition(BatchGetDevicePositionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchGetDevicePosition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetDevicePositionResult executeBatchGetDevicePosition(BatchGetDevicePositionRequest batchGetDevicePositionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetDevicePositionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetDevicePositionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetDevicePositionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchGetDevicePositionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchGetDevicePosition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchGetDevicePositionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            BatchGetDevicePositionResult batchGetDevicePositionResult = (BatchGetDevicePositionResult)response.getAwsResponse();
            return batchGetDevicePositionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchPutGeofenceResult batchPutGeofence(BatchPutGeofenceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchPutGeofence(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchPutGeofenceResult executeBatchPutGeofence(BatchPutGeofenceRequest batchPutGeofenceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchPutGeofenceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchPutGeofenceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchPutGeofenceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchPutGeofenceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchPutGeofence");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchPutGeofenceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            BatchPutGeofenceResult batchPutGeofenceResult = (BatchPutGeofenceResult)response.getAwsResponse();
            return batchPutGeofenceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchUpdateDevicePositionResult batchUpdateDevicePosition(BatchUpdateDevicePositionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchUpdateDevicePosition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchUpdateDevicePositionResult executeBatchUpdateDevicePosition(BatchUpdateDevicePositionRequest batchUpdateDevicePositionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchUpdateDevicePositionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchUpdateDevicePositionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchUpdateDevicePositionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchUpdateDevicePositionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchUpdateDevicePosition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchUpdateDevicePositionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            BatchUpdateDevicePositionResult batchUpdateDevicePositionResult = (BatchUpdateDevicePositionResult)response.getAwsResponse();
            return batchUpdateDevicePositionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CalculateRouteResult calculateRoute(CalculateRouteRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCalculateRoute(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CalculateRouteResult executeCalculateRoute(CalculateRouteRequest calculateRouteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(calculateRouteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CalculateRouteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CalculateRouteRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(calculateRouteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CalculateRoute");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "routes.";
                String resolvedHostPrefix = String.format("routes.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CalculateRouteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CalculateRouteResult calculateRouteResult = (CalculateRouteResult)response.getAwsResponse();
            return calculateRouteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateGeofenceCollectionResult createGeofenceCollection(CreateGeofenceCollectionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateGeofenceCollection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateGeofenceCollectionResult executeCreateGeofenceCollection(CreateGeofenceCollectionRequest createGeofenceCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGeofenceCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGeofenceCollectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGeofenceCollectionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createGeofenceCollectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateGeofenceCollection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateGeofenceCollectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreateGeofenceCollectionResult createGeofenceCollectionResult = (CreateGeofenceCollectionResult)response.getAwsResponse();
            return createGeofenceCollectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMapResult createMap(CreateMapRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateMap(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMapResult executeCreateMap(CreateMapRequest createMapRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMapRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMapRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMapRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createMapRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateMap");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateMapResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreateMapResult createMapResult = (CreateMapResult)response.getAwsResponse();
            return createMapResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePlaceIndexResult createPlaceIndex(CreatePlaceIndexRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreatePlaceIndex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePlaceIndexResult executeCreatePlaceIndex(CreatePlaceIndexRequest createPlaceIndexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPlaceIndexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePlaceIndexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePlaceIndexRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createPlaceIndexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreatePlaceIndex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "places.";
                String resolvedHostPrefix = String.format("places.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreatePlaceIndexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreatePlaceIndexResult createPlaceIndexResult = (CreatePlaceIndexResult)response.getAwsResponse();
            return createPlaceIndexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRouteCalculatorResult createRouteCalculator(CreateRouteCalculatorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateRouteCalculator(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRouteCalculatorResult executeCreateRouteCalculator(CreateRouteCalculatorRequest createRouteCalculatorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRouteCalculatorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRouteCalculatorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRouteCalculatorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createRouteCalculatorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateRouteCalculator");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "routes.";
                String resolvedHostPrefix = String.format("routes.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateRouteCalculatorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreateRouteCalculatorResult createRouteCalculatorResult = (CreateRouteCalculatorResult)response.getAwsResponse();
            return createRouteCalculatorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTrackerResult createTracker(CreateTrackerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateTracker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTrackerResult executeCreateTracker(CreateTrackerRequest createTrackerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTrackerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTrackerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTrackerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createTrackerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateTracker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateTrackerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreateTrackerResult createTrackerResult = (CreateTrackerResult)response.getAwsResponse();
            return createTrackerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteGeofenceCollectionResult deleteGeofenceCollection(DeleteGeofenceCollectionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteGeofenceCollection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteGeofenceCollectionResult executeDeleteGeofenceCollection(DeleteGeofenceCollectionRequest deleteGeofenceCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteGeofenceCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGeofenceCollectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGeofenceCollectionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteGeofenceCollectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteGeofenceCollection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteGeofenceCollectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteGeofenceCollectionResult deleteGeofenceCollectionResult = (DeleteGeofenceCollectionResult)response.getAwsResponse();
            return deleteGeofenceCollectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMapResult deleteMap(DeleteMapRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteMap(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMapResult executeDeleteMap(DeleteMapRequest deleteMapRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMapRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMapRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMapRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteMapRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteMap");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteMapResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteMapResult deleteMapResult = (DeleteMapResult)response.getAwsResponse();
            return deleteMapResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePlaceIndexResult deletePlaceIndex(DeletePlaceIndexRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeletePlaceIndex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePlaceIndexResult executeDeletePlaceIndex(DeletePlaceIndexRequest deletePlaceIndexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePlaceIndexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePlaceIndexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePlaceIndexRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deletePlaceIndexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeletePlaceIndex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "places.";
                String resolvedHostPrefix = String.format("places.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeletePlaceIndexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeletePlaceIndexResult deletePlaceIndexResult = (DeletePlaceIndexResult)response.getAwsResponse();
            return deletePlaceIndexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRouteCalculatorResult deleteRouteCalculator(DeleteRouteCalculatorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteRouteCalculator(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRouteCalculatorResult executeDeleteRouteCalculator(DeleteRouteCalculatorRequest deleteRouteCalculatorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRouteCalculatorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRouteCalculatorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRouteCalculatorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteRouteCalculatorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteRouteCalculator");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "routes.";
                String resolvedHostPrefix = String.format("routes.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteRouteCalculatorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteRouteCalculatorResult deleteRouteCalculatorResult = (DeleteRouteCalculatorResult)response.getAwsResponse();
            return deleteRouteCalculatorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTrackerResult deleteTracker(DeleteTrackerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteTracker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTrackerResult executeDeleteTracker(DeleteTrackerRequest deleteTrackerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTrackerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTrackerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTrackerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteTrackerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteTracker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteTrackerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteTrackerResult deleteTrackerResult = (DeleteTrackerResult)response.getAwsResponse();
            return deleteTrackerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeGeofenceCollectionResult describeGeofenceCollection(DescribeGeofenceCollectionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeGeofenceCollection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeGeofenceCollectionResult executeDescribeGeofenceCollection(DescribeGeofenceCollectionRequest describeGeofenceCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeGeofenceCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeGeofenceCollectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeGeofenceCollectionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeGeofenceCollectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeGeofenceCollection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeGeofenceCollectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DescribeGeofenceCollectionResult describeGeofenceCollectionResult = (DescribeGeofenceCollectionResult)response.getAwsResponse();
            return describeGeofenceCollectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeMapResult describeMap(DescribeMapRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeMap(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMapResult executeDescribeMap(DescribeMapRequest describeMapRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMapRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMapRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMapRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeMapRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeMap");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeMapResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DescribeMapResult describeMapResult = (DescribeMapResult)response.getAwsResponse();
            return describeMapResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePlaceIndexResult describePlaceIndex(DescribePlaceIndexRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribePlaceIndex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePlaceIndexResult executeDescribePlaceIndex(DescribePlaceIndexRequest describePlaceIndexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePlaceIndexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePlaceIndexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePlaceIndexRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describePlaceIndexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribePlaceIndex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "places.";
                String resolvedHostPrefix = String.format("places.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribePlaceIndexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DescribePlaceIndexResult describePlaceIndexResult = (DescribePlaceIndexResult)response.getAwsResponse();
            return describePlaceIndexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRouteCalculatorResult describeRouteCalculator(DescribeRouteCalculatorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeRouteCalculator(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRouteCalculatorResult executeDescribeRouteCalculator(DescribeRouteCalculatorRequest describeRouteCalculatorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRouteCalculatorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRouteCalculatorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRouteCalculatorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeRouteCalculatorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeRouteCalculator");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "routes.";
                String resolvedHostPrefix = String.format("routes.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeRouteCalculatorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DescribeRouteCalculatorResult describeRouteCalculatorResult = (DescribeRouteCalculatorResult)response.getAwsResponse();
            return describeRouteCalculatorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTrackerResult describeTracker(DescribeTrackerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeTracker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTrackerResult executeDescribeTracker(DescribeTrackerRequest describeTrackerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrackerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrackerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrackerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeTrackerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeTracker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTrackerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DescribeTrackerResult describeTrackerResult = (DescribeTrackerResult)response.getAwsResponse();
            return describeTrackerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateTrackerConsumerResult disassociateTrackerConsumer(DisassociateTrackerConsumerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateTrackerConsumer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateTrackerConsumerResult executeDisassociateTrackerConsumer(DisassociateTrackerConsumerRequest disassociateTrackerConsumerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateTrackerConsumerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateTrackerConsumerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateTrackerConsumerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateTrackerConsumerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DisassociateTrackerConsumer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateTrackerConsumerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DisassociateTrackerConsumerResult disassociateTrackerConsumerResult = (DisassociateTrackerConsumerResult)response.getAwsResponse();
            return disassociateTrackerConsumerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDevicePositionResult getDevicePosition(GetDevicePositionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDevicePosition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDevicePositionResult executeGetDevicePosition(GetDevicePositionRequest getDevicePositionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDevicePositionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDevicePositionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDevicePositionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDevicePositionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetDevicePosition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDevicePositionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetDevicePositionResult getDevicePositionResult = (GetDevicePositionResult)response.getAwsResponse();
            return getDevicePositionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDevicePositionHistoryResult getDevicePositionHistory(GetDevicePositionHistoryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDevicePositionHistory(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDevicePositionHistoryResult executeGetDevicePositionHistory(GetDevicePositionHistoryRequest getDevicePositionHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDevicePositionHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDevicePositionHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDevicePositionHistoryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDevicePositionHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetDevicePositionHistory");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDevicePositionHistoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetDevicePositionHistoryResult getDevicePositionHistoryResult = (GetDevicePositionHistoryResult)response.getAwsResponse();
            return getDevicePositionHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetGeofenceResult getGeofence(GetGeofenceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetGeofence(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetGeofenceResult executeGetGeofence(GetGeofenceRequest getGeofenceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getGeofenceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetGeofenceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetGeofenceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getGeofenceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetGeofence");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetGeofenceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetGeofenceResult getGeofenceResult = (GetGeofenceResult)response.getAwsResponse();
            return getGeofenceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMapGlyphsResult getMapGlyphs(GetMapGlyphsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetMapGlyphs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMapGlyphsResult executeGetMapGlyphs(GetMapGlyphsRequest getMapGlyphsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMapGlyphsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMapGlyphsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMapGlyphsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getMapGlyphsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetMapGlyphs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), new GetMapGlyphsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetMapGlyphsResult getMapGlyphsResult = (GetMapGlyphsResult)response.getAwsResponse();
            return getMapGlyphsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMapSpritesResult getMapSprites(GetMapSpritesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetMapSprites(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMapSpritesResult executeGetMapSprites(GetMapSpritesRequest getMapSpritesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMapSpritesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMapSpritesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMapSpritesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getMapSpritesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetMapSprites");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), new GetMapSpritesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetMapSpritesResult getMapSpritesResult = (GetMapSpritesResult)response.getAwsResponse();
            return getMapSpritesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMapStyleDescriptorResult getMapStyleDescriptor(GetMapStyleDescriptorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetMapStyleDescriptor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMapStyleDescriptorResult executeGetMapStyleDescriptor(GetMapStyleDescriptorRequest getMapStyleDescriptorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMapStyleDescriptorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMapStyleDescriptorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMapStyleDescriptorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getMapStyleDescriptorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetMapStyleDescriptor");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), new GetMapStyleDescriptorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetMapStyleDescriptorResult getMapStyleDescriptorResult = (GetMapStyleDescriptorResult)response.getAwsResponse();
            return getMapStyleDescriptorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMapTileResult getMapTile(GetMapTileRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetMapTile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMapTileResult executeGetMapTile(GetMapTileRequest getMapTileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMapTileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMapTileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMapTileRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getMapTileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetMapTile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), new GetMapTileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetMapTileResult getMapTileResult = (GetMapTileResult)response.getAwsResponse();
            return getMapTileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDevicePositionsResult listDevicePositions(ListDevicePositionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDevicePositions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDevicePositionsResult executeListDevicePositions(ListDevicePositionsRequest listDevicePositionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDevicePositionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDevicePositionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDevicePositionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listDevicePositionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListDevicePositions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListDevicePositionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListDevicePositionsResult listDevicePositionsResult = (ListDevicePositionsResult)response.getAwsResponse();
            return listDevicePositionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGeofenceCollectionsResult listGeofenceCollections(ListGeofenceCollectionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListGeofenceCollections(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGeofenceCollectionsResult executeListGeofenceCollections(ListGeofenceCollectionsRequest listGeofenceCollectionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGeofenceCollectionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGeofenceCollectionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGeofenceCollectionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listGeofenceCollectionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListGeofenceCollections");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListGeofenceCollectionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListGeofenceCollectionsResult listGeofenceCollectionsResult = (ListGeofenceCollectionsResult)response.getAwsResponse();
            return listGeofenceCollectionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGeofencesResult listGeofences(ListGeofencesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListGeofences(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGeofencesResult executeListGeofences(ListGeofencesRequest listGeofencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGeofencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGeofencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGeofencesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listGeofencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListGeofences");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListGeofencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListGeofencesResult listGeofencesResult = (ListGeofencesResult)response.getAwsResponse();
            return listGeofencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMapsResult listMaps(ListMapsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListMaps(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMapsResult executeListMaps(ListMapsRequest listMapsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMapsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMapsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMapsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listMapsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListMaps");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListMapsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListMapsResult listMapsResult = (ListMapsResult)response.getAwsResponse();
            return listMapsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPlaceIndexesResult listPlaceIndexes(ListPlaceIndexesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListPlaceIndexes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPlaceIndexesResult executeListPlaceIndexes(ListPlaceIndexesRequest listPlaceIndexesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPlaceIndexesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPlaceIndexesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPlaceIndexesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listPlaceIndexesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListPlaceIndexes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "places.";
                String resolvedHostPrefix = String.format("places.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListPlaceIndexesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListPlaceIndexesResult listPlaceIndexesResult = (ListPlaceIndexesResult)response.getAwsResponse();
            return listPlaceIndexesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRouteCalculatorsResult listRouteCalculators(ListRouteCalculatorsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRouteCalculators(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRouteCalculatorsResult executeListRouteCalculators(ListRouteCalculatorsRequest listRouteCalculatorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRouteCalculatorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRouteCalculatorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRouteCalculatorsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listRouteCalculatorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListRouteCalculators");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "routes.";
                String resolvedHostPrefix = String.format("routes.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRouteCalculatorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListRouteCalculatorsResult listRouteCalculatorsResult = (ListRouteCalculatorsResult)response.getAwsResponse();
            return listRouteCalculatorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "metadata.";
                String resolvedHostPrefix = String.format("metadata.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTrackerConsumersResult listTrackerConsumers(ListTrackerConsumersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTrackerConsumers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTrackerConsumersResult executeListTrackerConsumers(ListTrackerConsumersRequest listTrackerConsumersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTrackerConsumersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTrackerConsumersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTrackerConsumersRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTrackerConsumersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTrackerConsumers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTrackerConsumersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListTrackerConsumersResult listTrackerConsumersResult = (ListTrackerConsumersResult)response.getAwsResponse();
            return listTrackerConsumersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTrackersResult listTrackers(ListTrackersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTrackers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTrackersResult executeListTrackers(ListTrackersRequest listTrackersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTrackersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTrackersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTrackersRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTrackersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTrackers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTrackersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListTrackersResult listTrackersResult = (ListTrackersResult)response.getAwsResponse();
            return listTrackersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutGeofenceResult putGeofence(PutGeofenceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutGeofence(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutGeofenceResult executePutGeofence(PutGeofenceRequest putGeofenceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putGeofenceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutGeofenceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutGeofenceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putGeofenceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutGeofence");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutGeofenceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            PutGeofenceResult putGeofenceResult = (PutGeofenceResult)response.getAwsResponse();
            return putGeofenceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SearchPlaceIndexForPositionResult searchPlaceIndexForPosition(SearchPlaceIndexForPositionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSearchPlaceIndexForPosition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SearchPlaceIndexForPositionResult executeSearchPlaceIndexForPosition(SearchPlaceIndexForPositionRequest searchPlaceIndexForPositionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchPlaceIndexForPositionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchPlaceIndexForPositionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchPlaceIndexForPositionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(searchPlaceIndexForPositionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "SearchPlaceIndexForPosition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "places.";
                String resolvedHostPrefix = String.format("places.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SearchPlaceIndexForPositionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            SearchPlaceIndexForPositionResult searchPlaceIndexForPositionResult = (SearchPlaceIndexForPositionResult)response.getAwsResponse();
            return searchPlaceIndexForPositionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SearchPlaceIndexForTextResult searchPlaceIndexForText(SearchPlaceIndexForTextRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSearchPlaceIndexForText(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SearchPlaceIndexForTextResult executeSearchPlaceIndexForText(SearchPlaceIndexForTextRequest searchPlaceIndexForTextRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchPlaceIndexForTextRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchPlaceIndexForTextRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchPlaceIndexForTextRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(searchPlaceIndexForTextRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "SearchPlaceIndexForText");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "places.";
                String resolvedHostPrefix = String.format("places.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SearchPlaceIndexForTextResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            SearchPlaceIndexForTextResult searchPlaceIndexForTextResult = (SearchPlaceIndexForTextResult)response.getAwsResponse();
            return searchPlaceIndexForTextResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "metadata.";
                String resolvedHostPrefix = String.format("metadata.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "metadata.";
                String resolvedHostPrefix = String.format("metadata.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateGeofenceCollectionResult updateGeofenceCollection(UpdateGeofenceCollectionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateGeofenceCollection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateGeofenceCollectionResult executeUpdateGeofenceCollection(UpdateGeofenceCollectionRequest updateGeofenceCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateGeofenceCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGeofenceCollectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGeofenceCollectionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateGeofenceCollectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateGeofenceCollection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "geofencing.";
                String resolvedHostPrefix = String.format("geofencing.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateGeofenceCollectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateGeofenceCollectionResult updateGeofenceCollectionResult = (UpdateGeofenceCollectionResult)response.getAwsResponse();
            return updateGeofenceCollectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateMapResult updateMap(UpdateMapRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateMap(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateMapResult executeUpdateMap(UpdateMapRequest updateMapRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateMapRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateMapRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateMapRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateMapRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateMap");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "maps.";
                String resolvedHostPrefix = String.format("maps.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateMapResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateMapResult updateMapResult = (UpdateMapResult)response.getAwsResponse();
            return updateMapResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePlaceIndexResult updatePlaceIndex(UpdatePlaceIndexRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdatePlaceIndex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePlaceIndexResult executeUpdatePlaceIndex(UpdatePlaceIndexRequest updatePlaceIndexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePlaceIndexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePlaceIndexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePlaceIndexRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updatePlaceIndexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdatePlaceIndex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "places.";
                String resolvedHostPrefix = String.format("places.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdatePlaceIndexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdatePlaceIndexResult updatePlaceIndexResult = (UpdatePlaceIndexResult)response.getAwsResponse();
            return updatePlaceIndexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRouteCalculatorResult updateRouteCalculator(UpdateRouteCalculatorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateRouteCalculator(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRouteCalculatorResult executeUpdateRouteCalculator(UpdateRouteCalculatorRequest updateRouteCalculatorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRouteCalculatorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRouteCalculatorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRouteCalculatorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateRouteCalculatorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateRouteCalculator");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "routes.";
                String resolvedHostPrefix = String.format("routes.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRouteCalculatorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateRouteCalculatorResult updateRouteCalculatorResult = (UpdateRouteCalculatorResult)response.getAwsResponse();
            return updateRouteCalculatorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTrackerResult updateTracker(UpdateTrackerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateTracker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTrackerResult executeUpdateTracker(UpdateTrackerRequest updateTrackerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTrackerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTrackerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTrackerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateTrackerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Location");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateTracker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "tracking.";
                String resolvedHostPrefix = String.format("tracking.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost(this.endpoint, resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateTrackerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateTrackerResult updateTrackerResult = (UpdateTrackerResult)response.getAwsResponse();
            return updateTrackerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

