/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntimev2.model.transform.ValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Value
implements Serializable,
Cloneable,
StructuredPojo {
    private String originalValue;
    private String interpretedValue;
    private List<String> resolvedValues;

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public Value withOriginalValue(String originalValue) {
        this.setOriginalValue(originalValue);
        return this;
    }

    public void setInterpretedValue(String interpretedValue) {
        this.interpretedValue = interpretedValue;
    }

    public String getInterpretedValue() {
        return this.interpretedValue;
    }

    public Value withInterpretedValue(String interpretedValue) {
        this.setInterpretedValue(interpretedValue);
        return this;
    }

    public List<String> getResolvedValues() {
        return this.resolvedValues;
    }

    public void setResolvedValues(Collection<String> resolvedValues) {
        if (resolvedValues == null) {
            this.resolvedValues = null;
            return;
        }
        this.resolvedValues = new ArrayList<String>(resolvedValues);
    }

    public Value withResolvedValues(String ... resolvedValues) {
        if (this.resolvedValues == null) {
            this.setResolvedValues(new ArrayList<String>(resolvedValues.length));
        }
        for (String ele : resolvedValues) {
            this.resolvedValues.add(ele);
        }
        return this;
    }

    public Value withResolvedValues(Collection<String> resolvedValues) {
        this.setResolvedValues(resolvedValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOriginalValue() != null) {
            sb.append("OriginalValue: ").append(this.getOriginalValue()).append(",");
        }
        if (this.getInterpretedValue() != null) {
            sb.append("InterpretedValue: ").append(this.getInterpretedValue()).append(",");
        }
        if (this.getResolvedValues() != null) {
            sb.append("ResolvedValues: ").append(this.getResolvedValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value other = (Value)obj;
        if (other.getOriginalValue() == null ^ this.getOriginalValue() == null) {
            return false;
        }
        if (other.getOriginalValue() != null && !other.getOriginalValue().equals(this.getOriginalValue())) {
            return false;
        }
        if (other.getInterpretedValue() == null ^ this.getInterpretedValue() == null) {
            return false;
        }
        if (other.getInterpretedValue() != null && !other.getInterpretedValue().equals(this.getInterpretedValue())) {
            return false;
        }
        if (other.getResolvedValues() == null ^ this.getResolvedValues() == null) {
            return false;
        }
        return other.getResolvedValues() == null || other.getResolvedValues().equals(this.getResolvedValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOriginalValue() == null ? 0 : this.getOriginalValue().hashCode());
        hashCode = 31 * hashCode + (this.getInterpretedValue() == null ? 0 : this.getInterpretedValue().hashCode());
        hashCode = 31 * hashCode + (this.getResolvedValues() == null ? 0 : this.getResolvedValues().hashCode());
        return hashCode;
    }

    public Value clone() {
        try {
            return (Value)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

