/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntimev2.model.ConfirmationState;
import com.amazonaws.services.lexruntimev2.model.IntentState;
import com.amazonaws.services.lexruntimev2.model.Slot;
import com.amazonaws.services.lexruntimev2.model.transform.IntentMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Intent
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Map<String, Slot> slots;
    private String state;
    private String confirmationState;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Intent withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, Slot> getSlots() {
        return this.slots;
    }

    public void setSlots(Map<String, Slot> slots) {
        this.slots = slots;
    }

    public Intent withSlots(Map<String, Slot> slots) {
        this.setSlots(slots);
        return this;
    }

    public Intent addSlotsEntry(String key, Slot value) {
        if (null == this.slots) {
            this.slots = new HashMap<String, Slot>();
        }
        if (this.slots.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.slots.put(key, value);
        return this;
    }

    public Intent clearSlotsEntries() {
        this.slots = null;
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Intent withState(String state) {
        this.setState(state);
        return this;
    }

    public Intent withState(IntentState state) {
        this.state = state.toString();
        return this;
    }

    public void setConfirmationState(String confirmationState) {
        this.confirmationState = confirmationState;
    }

    public String getConfirmationState() {
        return this.confirmationState;
    }

    public Intent withConfirmationState(String confirmationState) {
        this.setConfirmationState(confirmationState);
        return this;
    }

    public Intent withConfirmationState(ConfirmationState confirmationState) {
        this.confirmationState = confirmationState.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSlots() != null) {
            sb.append("Slots: ").append(this.getSlots()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getConfirmationState() != null) {
            sb.append("ConfirmationState: ").append(this.getConfirmationState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Intent)) {
            return false;
        }
        Intent other = (Intent)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        if (other.getSlots() != null && !other.getSlots().equals(this.getSlots())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getConfirmationState() == null ^ this.getConfirmationState() == null) {
            return false;
        }
        return other.getConfirmationState() == null || other.getConfirmationState().equals(this.getConfirmationState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getConfirmationState() == null ? 0 : this.getConfirmationState().hashCode());
        return hashCode;
    }

    public Intent clone() {
        try {
            return (Intent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IntentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

