/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.lexmodelsv2.AmazonLexModelsV2;
import com.amazonaws.services.lexmodelsv2.model.DescribeBotAliasRequest;
import com.amazonaws.services.lexmodelsv2.model.DescribeBotAliasResult;
import com.amazonaws.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import com.amazonaws.services.lexmodelsv2.model.DescribeBotLocaleResult;
import com.amazonaws.services.lexmodelsv2.model.DescribeBotRequest;
import com.amazonaws.services.lexmodelsv2.model.DescribeBotResult;
import com.amazonaws.services.lexmodelsv2.model.DescribeBotVersionRequest;
import com.amazonaws.services.lexmodelsv2.model.DescribeBotVersionResult;
import com.amazonaws.services.lexmodelsv2.model.DescribeExportRequest;
import com.amazonaws.services.lexmodelsv2.model.DescribeExportResult;
import com.amazonaws.services.lexmodelsv2.model.DescribeImportRequest;
import com.amazonaws.services.lexmodelsv2.model.DescribeImportResult;
import com.amazonaws.services.lexmodelsv2.waiters.BotAliasAvailable;
import com.amazonaws.services.lexmodelsv2.waiters.BotAvailable;
import com.amazonaws.services.lexmodelsv2.waiters.BotExportCompleted;
import com.amazonaws.services.lexmodelsv2.waiters.BotImportCompleted;
import com.amazonaws.services.lexmodelsv2.waiters.BotLocaleBuilt;
import com.amazonaws.services.lexmodelsv2.waiters.BotLocaleCreated;
import com.amazonaws.services.lexmodelsv2.waiters.BotLocaleExpressTestingAvailable;
import com.amazonaws.services.lexmodelsv2.waiters.BotVersionAvailable;
import com.amazonaws.services.lexmodelsv2.waiters.DescribeBotAliasFunction;
import com.amazonaws.services.lexmodelsv2.waiters.DescribeBotFunction;
import com.amazonaws.services.lexmodelsv2.waiters.DescribeBotLocaleFunction;
import com.amazonaws.services.lexmodelsv2.waiters.DescribeBotVersionFunction;
import com.amazonaws.services.lexmodelsv2.waiters.DescribeExportFunction;
import com.amazonaws.services.lexmodelsv2.waiters.DescribeImportFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpFailureStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;

public class AmazonLexModelsV2Waiters {
    private final AmazonLexModelsV2 client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonLexModelsV2Waiters");

    @SdkInternalApi
    public AmazonLexModelsV2Waiters(AmazonLexModelsV2 client) {
        this.client = client;
    }

    public Waiter<DescribeExportRequest> botExportCompleted() {
        return new WaiterBuilder<DescribeExportRequest, DescribeExportResult>().withSdkFunction(new DescribeExportFunction(this.client)).withAcceptors(new BotExportCompleted.IsCompletedMatcher(), new BotExportCompleted.IsDeletingMatcher(), new BotExportCompleted.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(35), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeBotRequest> botAvailable() {
        return new WaiterBuilder<DescribeBotRequest, DescribeBotResult>().withSdkFunction(new DescribeBotFunction(this.client)).withAcceptors(new BotAvailable.IsAvailableMatcher(), new BotAvailable.IsDeletingMatcher(), new BotAvailable.IsFailedMatcher(), new BotAvailable.IsInactiveMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(35), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeBotAliasRequest> botAliasAvailable() {
        return new WaiterBuilder<DescribeBotAliasRequest, DescribeBotAliasResult>().withSdkFunction(new DescribeBotAliasFunction(this.client)).withAcceptors(new BotAliasAvailable.IsAvailableMatcher(), new BotAliasAvailable.IsFailedMatcher(), new BotAliasAvailable.IsDeletingMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(35), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImportRequest> botImportCompleted() {
        return new WaiterBuilder<DescribeImportRequest, DescribeImportResult>().withSdkFunction(new DescribeImportFunction(this.client)).withAcceptors(new BotImportCompleted.IsCompletedMatcher(), new BotImportCompleted.IsDeletingMatcher(), new BotImportCompleted.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(35), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeBotVersionRequest> botVersionAvailable() {
        return new WaiterBuilder<DescribeBotVersionRequest, DescribeBotVersionResult>().withSdkFunction(new DescribeBotVersionFunction(this.client)).withAcceptors(new BotVersionAvailable.IsAvailableMatcher(), new BotVersionAvailable.IsDeletingMatcher(), new BotVersionAvailable.IsFailedMatcher(), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(35), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeBotLocaleRequest> botLocaleExpressTestingAvailable() {
        return new WaiterBuilder<DescribeBotLocaleRequest, DescribeBotLocaleResult>().withSdkFunction(new DescribeBotLocaleFunction(this.client)).withAcceptors(new BotLocaleExpressTestingAvailable.IsBuiltMatcher(), new BotLocaleExpressTestingAvailable.IsReadyExpressTestingMatcher(), new BotLocaleExpressTestingAvailable.IsDeletingMatcher(), new BotLocaleExpressTestingAvailable.IsFailedMatcher(), new BotLocaleExpressTestingAvailable.IsNotBuiltMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(35), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeBotLocaleRequest> botLocaleBuilt() {
        return new WaiterBuilder<DescribeBotLocaleRequest, DescribeBotLocaleResult>().withSdkFunction(new DescribeBotLocaleFunction(this.client)).withAcceptors(new BotLocaleBuilt.IsBuiltMatcher(), new BotLocaleBuilt.IsDeletingMatcher(), new BotLocaleBuilt.IsFailedMatcher(), new BotLocaleBuilt.IsNotBuiltMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(35), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeBotLocaleRequest> botLocaleCreated() {
        return new WaiterBuilder<DescribeBotLocaleRequest, DescribeBotLocaleResult>().withSdkFunction(new DescribeBotLocaleFunction(this.client)).withAcceptors(new BotLocaleCreated.IsBuiltMatcher(), new BotLocaleCreated.IsReadyExpressTestingMatcher(), new BotLocaleCreated.IsNotBuiltMatcher(), new BotLocaleCreated.IsDeletingMatcher(), new BotLocaleCreated.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(35), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

