/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.Message;

@SdkInternalApi
public class MessageMarshaller {
    private static final MarshallingInfo<StructuredPojo> PLAINTEXTMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("plainTextMessage").build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMPAYLOAD_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customPayload").build();
    private static final MarshallingInfo<StructuredPojo> SSMLMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ssmlMessage").build();
    private static final MarshallingInfo<StructuredPojo> IMAGERESPONSECARD_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageResponseCard").build();
    private static final MessageMarshaller instance = new MessageMarshaller();

    public static MessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(Message message, ProtocolMarshaller protocolMarshaller) {
        if (message == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(message.getPlainTextMessage(), PLAINTEXTMESSAGE_BINDING);
            protocolMarshaller.marshall(message.getCustomPayload(), CUSTOMPAYLOAD_BINDING);
            protocolMarshaller.marshall(message.getSsmlMessage(), SSMLMESSAGE_BINDING);
            protocolMarshaller.marshall(message.getImageResponseCard(), IMAGERESPONSECARD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

