/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lexmodelsv2.model.BotFilter;
import com.amazonaws.services.lexmodelsv2.model.BotSortBy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBotsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private BotSortBy sortBy;
    private List<BotFilter> filters;
    private Integer maxResults;
    private String nextToken;

    public void setSortBy(BotSortBy sortBy) {
        this.sortBy = sortBy;
    }

    public BotSortBy getSortBy() {
        return this.sortBy;
    }

    public ListBotsRequest withSortBy(BotSortBy sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public List<BotFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<BotFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<BotFilter>(filters);
    }

    public ListBotsRequest withFilters(BotFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<BotFilter>(filters.length));
        }
        for (BotFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListBotsRequest withFilters(Collection<BotFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListBotsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListBotsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotsRequest)) {
            return false;
        }
        ListBotsRequest other = (ListBotsRequest)obj;
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListBotsRequest clone() {
        return (ListBotsRequest)super.clone();
    }
}

