/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.Button;
import com.amazonaws.services.lexmodelsv2.model.transform.ImageResponseCardMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageResponseCard
implements Serializable,
Cloneable,
StructuredPojo {
    private String title;
    private String subtitle;
    private String imageUrl;
    private List<Button> buttons;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public ImageResponseCard withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public ImageResponseCard withSubtitle(String subtitle) {
        this.setSubtitle(subtitle);
        return this;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public ImageResponseCard withImageUrl(String imageUrl) {
        this.setImageUrl(imageUrl);
        return this;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public void setButtons(Collection<Button> buttons) {
        if (buttons == null) {
            this.buttons = null;
            return;
        }
        this.buttons = new ArrayList<Button>(buttons);
    }

    public ImageResponseCard withButtons(Button ... buttons) {
        if (this.buttons == null) {
            this.setButtons(new ArrayList<Button>(buttons.length));
        }
        for (Button ele : buttons) {
            this.buttons.add(ele);
        }
        return this;
    }

    public ImageResponseCard withButtons(Collection<Button> buttons) {
        this.setButtons(buttons);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getSubtitle() != null) {
            sb.append("Subtitle: ").append(this.getSubtitle()).append(",");
        }
        if (this.getImageUrl() != null) {
            sb.append("ImageUrl: ").append(this.getImageUrl()).append(",");
        }
        if (this.getButtons() != null) {
            sb.append("Buttons: ").append(this.getButtons());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageResponseCard)) {
            return false;
        }
        ImageResponseCard other = (ImageResponseCard)obj;
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getSubtitle() == null ^ this.getSubtitle() == null) {
            return false;
        }
        if (other.getSubtitle() != null && !other.getSubtitle().equals(this.getSubtitle())) {
            return false;
        }
        if (other.getImageUrl() == null ^ this.getImageUrl() == null) {
            return false;
        }
        if (other.getImageUrl() != null && !other.getImageUrl().equals(this.getImageUrl())) {
            return false;
        }
        if (other.getButtons() == null ^ this.getButtons() == null) {
            return false;
        }
        return other.getButtons() == null || other.getButtons().equals(this.getButtons());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getSubtitle() == null ? 0 : this.getSubtitle().hashCode());
        hashCode = 31 * hashCode + (this.getImageUrl() == null ? 0 : this.getImageUrl().hashCode());
        hashCode = 31 * hashCode + (this.getButtons() == null ? 0 : this.getButtons().hashCode());
        return hashCode;
    }

    public ImageResponseCard clone() {
        try {
            return (ImageResponseCard)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageResponseCardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

