/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.ExperimentAction;
import com.amazonaws.services.fis.model.ExperimentState;
import com.amazonaws.services.fis.model.ExperimentStopCondition;
import com.amazonaws.services.fis.model.ExperimentTarget;
import com.amazonaws.services.fis.model.transform.ExperimentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Experiment
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String experimentTemplateId;
    private String roleArn;
    private ExperimentState state;
    private Map<String, ExperimentTarget> targets;
    private Map<String, ExperimentAction> actions;
    private List<ExperimentStopCondition> stopConditions;
    private Date creationTime;
    private Date startTime;
    private Date endTime;
    private Map<String, String> tags;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Experiment withId(String id) {
        this.setId(id);
        return this;
    }

    public void setExperimentTemplateId(String experimentTemplateId) {
        this.experimentTemplateId = experimentTemplateId;
    }

    public String getExperimentTemplateId() {
        return this.experimentTemplateId;
    }

    public Experiment withExperimentTemplateId(String experimentTemplateId) {
        this.setExperimentTemplateId(experimentTemplateId);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public Experiment withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setState(ExperimentState state) {
        this.state = state;
    }

    public ExperimentState getState() {
        return this.state;
    }

    public Experiment withState(ExperimentState state) {
        this.setState(state);
        return this;
    }

    public Map<String, ExperimentTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, ExperimentTarget> targets) {
        this.targets = targets;
    }

    public Experiment withTargets(Map<String, ExperimentTarget> targets) {
        this.setTargets(targets);
        return this;
    }

    public Experiment addTargetsEntry(String key, ExperimentTarget value) {
        if (null == this.targets) {
            this.targets = new HashMap<String, ExperimentTarget>();
        }
        if (this.targets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.targets.put(key, value);
        return this;
    }

    public Experiment clearTargetsEntries() {
        this.targets = null;
        return this;
    }

    public Map<String, ExperimentAction> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, ExperimentAction> actions) {
        this.actions = actions;
    }

    public Experiment withActions(Map<String, ExperimentAction> actions) {
        this.setActions(actions);
        return this;
    }

    public Experiment addActionsEntry(String key, ExperimentAction value) {
        if (null == this.actions) {
            this.actions = new HashMap<String, ExperimentAction>();
        }
        if (this.actions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.actions.put(key, value);
        return this;
    }

    public Experiment clearActionsEntries() {
        this.actions = null;
        return this;
    }

    public List<ExperimentStopCondition> getStopConditions() {
        return this.stopConditions;
    }

    public void setStopConditions(Collection<ExperimentStopCondition> stopConditions) {
        if (stopConditions == null) {
            this.stopConditions = null;
            return;
        }
        this.stopConditions = new ArrayList<ExperimentStopCondition>(stopConditions);
    }

    public Experiment withStopConditions(ExperimentStopCondition ... stopConditions) {
        if (this.stopConditions == null) {
            this.setStopConditions(new ArrayList<ExperimentStopCondition>(stopConditions.length));
        }
        for (ExperimentStopCondition ele : stopConditions) {
            this.stopConditions.add(ele);
        }
        return this;
    }

    public Experiment withStopConditions(Collection<ExperimentStopCondition> stopConditions) {
        this.setStopConditions(stopConditions);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Experiment withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Experiment withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Experiment withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Experiment withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Experiment addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Experiment clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getExperimentTemplateId() != null) {
            sb.append("ExperimentTemplateId: ").append(this.getExperimentTemplateId()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getStopConditions() != null) {
            sb.append("StopConditions: ").append(this.getStopConditions()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getExperimentTemplateId() == null ^ this.getExperimentTemplateId() == null) {
            return false;
        }
        if (other.getExperimentTemplateId() != null && !other.getExperimentTemplateId().equals(this.getExperimentTemplateId())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getStopConditions() == null ^ this.getStopConditions() == null) {
            return false;
        }
        if (other.getStopConditions() != null && !other.getStopConditions().equals(this.getStopConditions())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getExperimentTemplateId() == null ? 0 : this.getExperimentTemplateId().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getStopConditions() == null ? 0 : this.getStopConditions().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Experiment clone() {
        try {
            return (Experiment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExperimentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

