/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataAsync;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataAsyncClientBuilder;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataClient;
import com.amazonaws.services.finspacedata.model.CreateChangesetRequest;
import com.amazonaws.services.finspacedata.model.CreateChangesetResult;
import com.amazonaws.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest;
import com.amazonaws.services.finspacedata.model.GetProgrammaticAccessCredentialsResult;
import com.amazonaws.services.finspacedata.model.GetWorkingLocationRequest;
import com.amazonaws.services.finspacedata.model.GetWorkingLocationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSFinSpaceDataAsyncClient
extends AWSFinSpaceDataClient
implements AWSFinSpaceDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSFinSpaceDataAsyncClientBuilder asyncBuilder() {
        return AWSFinSpaceDataAsyncClientBuilder.standard();
    }

    AWSFinSpaceDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSFinSpaceDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateChangesetResult> createChangesetAsync(CreateChangesetRequest request) {
        return this.createChangesetAsync(request, null);
    }

    @Override
    public Future<CreateChangesetResult> createChangesetAsync(CreateChangesetRequest request, final AsyncHandler<CreateChangesetRequest, CreateChangesetResult> asyncHandler) {
        final CreateChangesetRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChangesetResult>(){

            @Override
            public CreateChangesetResult call() throws Exception {
                CreateChangesetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreateChangeset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProgrammaticAccessCredentialsResult> getProgrammaticAccessCredentialsAsync(GetProgrammaticAccessCredentialsRequest request) {
        return this.getProgrammaticAccessCredentialsAsync(request, null);
    }

    @Override
    public Future<GetProgrammaticAccessCredentialsResult> getProgrammaticAccessCredentialsAsync(GetProgrammaticAccessCredentialsRequest request, final AsyncHandler<GetProgrammaticAccessCredentialsRequest, GetProgrammaticAccessCredentialsResult> asyncHandler) {
        final GetProgrammaticAccessCredentialsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProgrammaticAccessCredentialsResult>(){

            @Override
            public GetProgrammaticAccessCredentialsResult call() throws Exception {
                GetProgrammaticAccessCredentialsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetProgrammaticAccessCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkingLocationResult> getWorkingLocationAsync(GetWorkingLocationRequest request) {
        return this.getWorkingLocationAsync(request, null);
    }

    @Override
    public Future<GetWorkingLocationResult> getWorkingLocationAsync(GetWorkingLocationRequest request, final AsyncHandler<GetWorkingLocationRequest, GetWorkingLocationResult> asyncHandler) {
        final GetWorkingLocationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkingLocationResult>(){

            @Override
            public GetWorkingLocationResult call() throws Exception {
                GetWorkingLocationResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetWorkingLocation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

