/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.finspace.model.transform.FederationParametersMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class FederationParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private String samlMetadataDocument;
    private String samlMetadataURL;
    private String applicationCallBackURL;
    private String federationURN;
    private String federationProviderName;
    private Map<String, String> attributeMap;

    public void setSamlMetadataDocument(String samlMetadataDocument) {
        this.samlMetadataDocument = samlMetadataDocument;
    }

    public String getSamlMetadataDocument() {
        return this.samlMetadataDocument;
    }

    public FederationParameters withSamlMetadataDocument(String samlMetadataDocument) {
        this.setSamlMetadataDocument(samlMetadataDocument);
        return this;
    }

    public void setSamlMetadataURL(String samlMetadataURL) {
        this.samlMetadataURL = samlMetadataURL;
    }

    public String getSamlMetadataURL() {
        return this.samlMetadataURL;
    }

    public FederationParameters withSamlMetadataURL(String samlMetadataURL) {
        this.setSamlMetadataURL(samlMetadataURL);
        return this;
    }

    public void setApplicationCallBackURL(String applicationCallBackURL) {
        this.applicationCallBackURL = applicationCallBackURL;
    }

    public String getApplicationCallBackURL() {
        return this.applicationCallBackURL;
    }

    public FederationParameters withApplicationCallBackURL(String applicationCallBackURL) {
        this.setApplicationCallBackURL(applicationCallBackURL);
        return this;
    }

    public void setFederationURN(String federationURN) {
        this.federationURN = federationURN;
    }

    public String getFederationURN() {
        return this.federationURN;
    }

    public FederationParameters withFederationURN(String federationURN) {
        this.setFederationURN(federationURN);
        return this;
    }

    public void setFederationProviderName(String federationProviderName) {
        this.federationProviderName = federationProviderName;
    }

    public String getFederationProviderName() {
        return this.federationProviderName;
    }

    public FederationParameters withFederationProviderName(String federationProviderName) {
        this.setFederationProviderName(federationProviderName);
        return this;
    }

    public Map<String, String> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<String, String> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public FederationParameters withAttributeMap(Map<String, String> attributeMap) {
        this.setAttributeMap(attributeMap);
        return this;
    }

    public FederationParameters addAttributeMapEntry(String key, String value) {
        if (null == this.attributeMap) {
            this.attributeMap = new HashMap<String, String>();
        }
        if (this.attributeMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributeMap.put(key, value);
        return this;
    }

    public FederationParameters clearAttributeMapEntries() {
        this.attributeMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSamlMetadataDocument() != null) {
            sb.append("SamlMetadataDocument: ").append(this.getSamlMetadataDocument()).append(",");
        }
        if (this.getSamlMetadataURL() != null) {
            sb.append("SamlMetadataURL: ").append(this.getSamlMetadataURL()).append(",");
        }
        if (this.getApplicationCallBackURL() != null) {
            sb.append("ApplicationCallBackURL: ").append(this.getApplicationCallBackURL()).append(",");
        }
        if (this.getFederationURN() != null) {
            sb.append("FederationURN: ").append(this.getFederationURN()).append(",");
        }
        if (this.getFederationProviderName() != null) {
            sb.append("FederationProviderName: ").append(this.getFederationProviderName()).append(",");
        }
        if (this.getAttributeMap() != null) {
            sb.append("AttributeMap: ").append(this.getAttributeMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FederationParameters)) {
            return false;
        }
        FederationParameters other = (FederationParameters)obj;
        if (other.getSamlMetadataDocument() == null ^ this.getSamlMetadataDocument() == null) {
            return false;
        }
        if (other.getSamlMetadataDocument() != null && !other.getSamlMetadataDocument().equals(this.getSamlMetadataDocument())) {
            return false;
        }
        if (other.getSamlMetadataURL() == null ^ this.getSamlMetadataURL() == null) {
            return false;
        }
        if (other.getSamlMetadataURL() != null && !other.getSamlMetadataURL().equals(this.getSamlMetadataURL())) {
            return false;
        }
        if (other.getApplicationCallBackURL() == null ^ this.getApplicationCallBackURL() == null) {
            return false;
        }
        if (other.getApplicationCallBackURL() != null && !other.getApplicationCallBackURL().equals(this.getApplicationCallBackURL())) {
            return false;
        }
        if (other.getFederationURN() == null ^ this.getFederationURN() == null) {
            return false;
        }
        if (other.getFederationURN() != null && !other.getFederationURN().equals(this.getFederationURN())) {
            return false;
        }
        if (other.getFederationProviderName() == null ^ this.getFederationProviderName() == null) {
            return false;
        }
        if (other.getFederationProviderName() != null && !other.getFederationProviderName().equals(this.getFederationProviderName())) {
            return false;
        }
        if (other.getAttributeMap() == null ^ this.getAttributeMap() == null) {
            return false;
        }
        return other.getAttributeMap() == null || other.getAttributeMap().equals(this.getAttributeMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSamlMetadataDocument() == null ? 0 : this.getSamlMetadataDocument().hashCode());
        hashCode = 31 * hashCode + (this.getSamlMetadataURL() == null ? 0 : this.getSamlMetadataURL().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationCallBackURL() == null ? 0 : this.getApplicationCallBackURL().hashCode());
        hashCode = 31 * hashCode + (this.getFederationURN() == null ? 0 : this.getFederationURN().hashCode());
        hashCode = 31 * hashCode + (this.getFederationProviderName() == null ? 0 : this.getFederationProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeMap() == null ? 0 : this.getAttributeMap().hashCode());
        return hashCode;
    }

    public FederationParameters clone() {
        try {
            return (FederationParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FederationParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

