/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.finspace.AWSfinspaceAsync;
import com.amazonaws.services.finspace.AWSfinspaceAsyncClientBuilder;
import com.amazonaws.services.finspace.AWSfinspaceClient;
import com.amazonaws.services.finspace.model.CreateEnvironmentRequest;
import com.amazonaws.services.finspace.model.CreateEnvironmentResult;
import com.amazonaws.services.finspace.model.DeleteEnvironmentRequest;
import com.amazonaws.services.finspace.model.DeleteEnvironmentResult;
import com.amazonaws.services.finspace.model.GetEnvironmentRequest;
import com.amazonaws.services.finspace.model.GetEnvironmentResult;
import com.amazonaws.services.finspace.model.ListEnvironmentsRequest;
import com.amazonaws.services.finspace.model.ListEnvironmentsResult;
import com.amazonaws.services.finspace.model.ListTagsForResourceRequest;
import com.amazonaws.services.finspace.model.ListTagsForResourceResult;
import com.amazonaws.services.finspace.model.TagResourceRequest;
import com.amazonaws.services.finspace.model.TagResourceResult;
import com.amazonaws.services.finspace.model.UntagResourceRequest;
import com.amazonaws.services.finspace.model.UntagResourceResult;
import com.amazonaws.services.finspace.model.UpdateEnvironmentRequest;
import com.amazonaws.services.finspace.model.UpdateEnvironmentResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSfinspaceAsyncClient
extends AWSfinspaceClient
implements AWSfinspaceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSfinspaceAsyncClientBuilder asyncBuilder() {
        return AWSfinspaceAsyncClientBuilder.standard();
    }

    AWSfinspaceAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSfinspaceAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateEnvironmentResult> createEnvironmentAsync(CreateEnvironmentRequest request) {
        return this.createEnvironmentAsync(request, null);
    }

    @Override
    public Future<CreateEnvironmentResult> createEnvironmentAsync(CreateEnvironmentRequest request, final AsyncHandler<CreateEnvironmentRequest, CreateEnvironmentResult> asyncHandler) {
        final CreateEnvironmentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEnvironmentResult>(){

            @Override
            public CreateEnvironmentResult call() throws Exception {
                CreateEnvironmentResult result = null;
                try {
                    result = AWSfinspaceAsyncClient.this.executeCreateEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEnvironmentResult> deleteEnvironmentAsync(DeleteEnvironmentRequest request) {
        return this.deleteEnvironmentAsync(request, null);
    }

    @Override
    public Future<DeleteEnvironmentResult> deleteEnvironmentAsync(DeleteEnvironmentRequest request, final AsyncHandler<DeleteEnvironmentRequest, DeleteEnvironmentResult> asyncHandler) {
        final DeleteEnvironmentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEnvironmentResult>(){

            @Override
            public DeleteEnvironmentResult call() throws Exception {
                DeleteEnvironmentResult result = null;
                try {
                    result = AWSfinspaceAsyncClient.this.executeDeleteEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEnvironmentResult> getEnvironmentAsync(GetEnvironmentRequest request) {
        return this.getEnvironmentAsync(request, null);
    }

    @Override
    public Future<GetEnvironmentResult> getEnvironmentAsync(GetEnvironmentRequest request, final AsyncHandler<GetEnvironmentRequest, GetEnvironmentResult> asyncHandler) {
        final GetEnvironmentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEnvironmentResult>(){

            @Override
            public GetEnvironmentResult call() throws Exception {
                GetEnvironmentResult result = null;
                try {
                    result = AWSfinspaceAsyncClient.this.executeGetEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEnvironmentsResult> listEnvironmentsAsync(ListEnvironmentsRequest request) {
        return this.listEnvironmentsAsync(request, null);
    }

    @Override
    public Future<ListEnvironmentsResult> listEnvironmentsAsync(ListEnvironmentsRequest request, final AsyncHandler<ListEnvironmentsRequest, ListEnvironmentsResult> asyncHandler) {
        final ListEnvironmentsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEnvironmentsResult>(){

            @Override
            public ListEnvironmentsResult call() throws Exception {
                ListEnvironmentsResult result = null;
                try {
                    result = AWSfinspaceAsyncClient.this.executeListEnvironments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSfinspaceAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSfinspaceAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSfinspaceAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEnvironmentResult> updateEnvironmentAsync(UpdateEnvironmentRequest request) {
        return this.updateEnvironmentAsync(request, null);
    }

    @Override
    public Future<UpdateEnvironmentResult> updateEnvironmentAsync(UpdateEnvironmentRequest request, final AsyncHandler<UpdateEnvironmentRequest, UpdateEnvironmentResult> asyncHandler) {
        final UpdateEnvironmentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEnvironmentResult>(){

            @Override
            public UpdateEnvironmentResult call() throws Exception {
                UpdateEnvironmentResult result = null;
                try {
                    result = AWSfinspaceAsyncClient.this.executeUpdateEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

