/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apprunner.model.SourceConfiguration;

@SdkInternalApi
public class SourceConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> CODEREPOSITORY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeRepository").build();
    private static final MarshallingInfo<StructuredPojo> IMAGEREPOSITORY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageRepository").build();
    private static final MarshallingInfo<Boolean> AUTODEPLOYMENTSENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoDeploymentsEnabled").build();
    private static final MarshallingInfo<StructuredPojo> AUTHENTICATIONCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthenticationConfiguration").build();
    private static final SourceConfigurationMarshaller instance = new SourceConfigurationMarshaller();

    public static SourceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceConfiguration sourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (sourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sourceConfiguration.getCodeRepository(), CODEREPOSITORY_BINDING);
            protocolMarshaller.marshall(sourceConfiguration.getImageRepository(), IMAGEREPOSITORY_BINDING);
            protocolMarshaller.marshall(sourceConfiguration.getAutoDeploymentsEnabled(), AUTODEPLOYMENTSENABLED_BINDING);
            protocolMarshaller.marshall(sourceConfiguration.getAuthenticationConfiguration(), AUTHENTICATIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

