/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apprunner.model.InstanceConfiguration;

@SdkInternalApi
public class InstanceConfigurationMarshaller {
    private static final MarshallingInfo<String> CPU_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cpu").build();
    private static final MarshallingInfo<String> MEMORY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Memory").build();
    private static final MarshallingInfo<String> INSTANCEROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceRoleArn").build();
    private static final InstanceConfigurationMarshaller instance = new InstanceConfigurationMarshaller();

    public static InstanceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceConfiguration instanceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (instanceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(instanceConfiguration.getCpu(), CPU_BINDING);
            protocolMarshaller.marshall(instanceConfiguration.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall(instanceConfiguration.getInstanceRoleArn(), INSTANCEROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

