/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apprunner.model.ImageRepository;

@SdkInternalApi
public class ImageRepositoryMarshaller {
    private static final MarshallingInfo<String> IMAGEIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageIdentifier").build();
    private static final MarshallingInfo<StructuredPojo> IMAGECONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageConfiguration").build();
    private static final MarshallingInfo<String> IMAGEREPOSITORYTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageRepositoryType").build();
    private static final ImageRepositoryMarshaller instance = new ImageRepositoryMarshaller();

    public static ImageRepositoryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageRepository imageRepository, ProtocolMarshaller protocolMarshaller) {
        if (imageRepository == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(imageRepository.getImageIdentifier(), IMAGEIDENTIFIER_BINDING);
            protocolMarshaller.marshall(imageRepository.getImageConfiguration(), IMAGECONFIGURATION_BINDING);
            protocolMarshaller.marshall(imageRepository.getImageRepositoryType(), IMAGEREPOSITORYTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

