/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apprunner.model.ConnectionSummary;
import java.util.Date;

@SdkInternalApi
public class ConnectionSummaryMarshaller {
    private static final MarshallingInfo<String> CONNECTIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionName").build();
    private static final MarshallingInfo<String> CONNECTIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionArn").build();
    private static final MarshallingInfo<String> PROVIDERTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final ConnectionSummaryMarshaller instance = new ConnectionSummaryMarshaller();

    public static ConnectionSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConnectionSummary connectionSummary, ProtocolMarshaller protocolMarshaller) {
        if (connectionSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(connectionSummary.getConnectionName(), CONNECTIONNAME_BINDING);
            protocolMarshaller.marshall(connectionSummary.getConnectionArn(), CONNECTIONARN_BINDING);
            protocolMarshaller.marshall(connectionSummary.getProviderType(), PROVIDERTYPE_BINDING);
            protocolMarshaller.marshall(connectionSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(connectionSummary.getCreatedAt(), CREATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

