/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apprunner.model.CodeRepository;

@SdkInternalApi
public class CodeRepositoryMarshaller {
    private static final MarshallingInfo<String> REPOSITORYURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RepositoryUrl").build();
    private static final MarshallingInfo<StructuredPojo> SOURCECODEVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceCodeVersion").build();
    private static final MarshallingInfo<StructuredPojo> CODECONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeConfiguration").build();
    private static final CodeRepositoryMarshaller instance = new CodeRepositoryMarshaller();

    public static CodeRepositoryMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeRepository codeRepository, ProtocolMarshaller protocolMarshaller) {
        if (codeRepository == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(codeRepository.getRepositoryUrl(), REPOSITORYURL_BINDING);
            protocolMarshaller.marshall(codeRepository.getSourceCodeVersion(), SOURCECODEVERSION_BINDING);
            protocolMarshaller.marshall(codeRepository.getCodeConfiguration(), CODECONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

