/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationcostprofiler.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.applicationcostprofiler.model.SourceS3Location;

@SdkInternalApi
public class SourceS3LocationMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final SourceS3LocationMarshaller instance = new SourceS3LocationMarshaller();

    public static SourceS3LocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceS3Location sourceS3Location, ProtocolMarshaller protocolMarshaller) {
        if (sourceS3Location == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sourceS3Location.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall(sourceS3Location.getKey(), KEY_BINDING);
            protocolMarshaller.marshall(sourceS3Location.getRegion(), REGION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

