/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationcostprofiler.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationcostprofiler.model.ReportDefinition;
import java.util.Date;

@SdkInternalApi
public class ReportDefinitionMarshaller {
    private static final MarshallingInfo<String> REPORTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reportId").build();
    private static final MarshallingInfo<String> REPORTDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reportDescription").build();
    private static final MarshallingInfo<String> REPORTFREQUENCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reportFrequency").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("format").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONS3LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationS3Location").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final ReportDefinitionMarshaller instance = new ReportDefinitionMarshaller();

    public static ReportDefinitionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReportDefinition reportDefinition, ProtocolMarshaller protocolMarshaller) {
        if (reportDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(reportDefinition.getReportId(), REPORTID_BINDING);
            protocolMarshaller.marshall(reportDefinition.getReportDescription(), REPORTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(reportDefinition.getReportFrequency(), REPORTFREQUENCY_BINDING);
            protocolMarshaller.marshall(reportDefinition.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall(reportDefinition.getDestinationS3Location(), DESTINATIONS3LOCATION_BINDING);
            protocolMarshaller.marshall(reportDefinition.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(reportDefinition.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

