/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssmincidents;

import javax.annotation.Generated;

import com.amazonaws.services.ssmincidents.model.*;

/**
 * Abstract implementation of {@code AWSSSMIncidentsAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSSMIncidentsAsync extends AbstractAWSSSMIncidents implements AWSSSMIncidentsAsync {

    protected AbstractAWSSSMIncidentsAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateReplicationSetResult> createReplicationSetAsync(CreateReplicationSetRequest request) {

        return createReplicationSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateReplicationSetResult> createReplicationSetAsync(CreateReplicationSetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateReplicationSetRequest, CreateReplicationSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateResponsePlanResult> createResponsePlanAsync(CreateResponsePlanRequest request) {

        return createResponsePlanAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateResponsePlanResult> createResponsePlanAsync(CreateResponsePlanRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateResponsePlanRequest, CreateResponsePlanResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTimelineEventResult> createTimelineEventAsync(CreateTimelineEventRequest request) {

        return createTimelineEventAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTimelineEventResult> createTimelineEventAsync(CreateTimelineEventRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTimelineEventRequest, CreateTimelineEventResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIncidentRecordResult> deleteIncidentRecordAsync(DeleteIncidentRecordRequest request) {

        return deleteIncidentRecordAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIncidentRecordResult> deleteIncidentRecordAsync(DeleteIncidentRecordRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIncidentRecordRequest, DeleteIncidentRecordResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteReplicationSetResult> deleteReplicationSetAsync(DeleteReplicationSetRequest request) {

        return deleteReplicationSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteReplicationSetResult> deleteReplicationSetAsync(DeleteReplicationSetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteReplicationSetRequest, DeleteReplicationSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request) {

        return deleteResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteResourcePolicyRequest, DeleteResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteResponsePlanResult> deleteResponsePlanAsync(DeleteResponsePlanRequest request) {

        return deleteResponsePlanAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteResponsePlanResult> deleteResponsePlanAsync(DeleteResponsePlanRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteResponsePlanRequest, DeleteResponsePlanResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTimelineEventResult> deleteTimelineEventAsync(DeleteTimelineEventRequest request) {

        return deleteTimelineEventAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTimelineEventResult> deleteTimelineEventAsync(DeleteTimelineEventRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTimelineEventRequest, DeleteTimelineEventResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIncidentRecordResult> getIncidentRecordAsync(GetIncidentRecordRequest request) {

        return getIncidentRecordAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIncidentRecordResult> getIncidentRecordAsync(GetIncidentRecordRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIncidentRecordRequest, GetIncidentRecordResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetReplicationSetResult> getReplicationSetAsync(GetReplicationSetRequest request) {

        return getReplicationSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetReplicationSetResult> getReplicationSetAsync(GetReplicationSetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetReplicationSetRequest, GetReplicationSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetResourcePoliciesResult> getResourcePoliciesAsync(GetResourcePoliciesRequest request) {

        return getResourcePoliciesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetResourcePoliciesResult> getResourcePoliciesAsync(GetResourcePoliciesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetResourcePoliciesRequest, GetResourcePoliciesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetResponsePlanResult> getResponsePlanAsync(GetResponsePlanRequest request) {

        return getResponsePlanAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetResponsePlanResult> getResponsePlanAsync(GetResponsePlanRequest request,
            com.amazonaws.handlers.AsyncHandler<GetResponsePlanRequest, GetResponsePlanResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTimelineEventResult> getTimelineEventAsync(GetTimelineEventRequest request) {

        return getTimelineEventAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTimelineEventResult> getTimelineEventAsync(GetTimelineEventRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTimelineEventRequest, GetTimelineEventResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListIncidentRecordsResult> listIncidentRecordsAsync(ListIncidentRecordsRequest request) {

        return listIncidentRecordsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListIncidentRecordsResult> listIncidentRecordsAsync(ListIncidentRecordsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListIncidentRecordsRequest, ListIncidentRecordsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRelatedItemsResult> listRelatedItemsAsync(ListRelatedItemsRequest request) {

        return listRelatedItemsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRelatedItemsResult> listRelatedItemsAsync(ListRelatedItemsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRelatedItemsRequest, ListRelatedItemsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListReplicationSetsResult> listReplicationSetsAsync(ListReplicationSetsRequest request) {

        return listReplicationSetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListReplicationSetsResult> listReplicationSetsAsync(ListReplicationSetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListReplicationSetsRequest, ListReplicationSetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListResponsePlansResult> listResponsePlansAsync(ListResponsePlansRequest request) {

        return listResponsePlansAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListResponsePlansResult> listResponsePlansAsync(ListResponsePlansRequest request,
            com.amazonaws.handlers.AsyncHandler<ListResponsePlansRequest, ListResponsePlansResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTimelineEventsResult> listTimelineEventsAsync(ListTimelineEventsRequest request) {

        return listTimelineEventsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTimelineEventsResult> listTimelineEventsAsync(ListTimelineEventsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTimelineEventsRequest, ListTimelineEventsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request) {

        return putResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<PutResourcePolicyRequest, PutResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartIncidentResult> startIncidentAsync(StartIncidentRequest request) {

        return startIncidentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartIncidentResult> startIncidentAsync(StartIncidentRequest request,
            com.amazonaws.handlers.AsyncHandler<StartIncidentRequest, StartIncidentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDeletionProtectionResult> updateDeletionProtectionAsync(UpdateDeletionProtectionRequest request) {

        return updateDeletionProtectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDeletionProtectionResult> updateDeletionProtectionAsync(UpdateDeletionProtectionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDeletionProtectionRequest, UpdateDeletionProtectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateIncidentRecordResult> updateIncidentRecordAsync(UpdateIncidentRecordRequest request) {

        return updateIncidentRecordAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateIncidentRecordResult> updateIncidentRecordAsync(UpdateIncidentRecordRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateIncidentRecordRequest, UpdateIncidentRecordResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRelatedItemsResult> updateRelatedItemsAsync(UpdateRelatedItemsRequest request) {

        return updateRelatedItemsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRelatedItemsResult> updateRelatedItemsAsync(UpdateRelatedItemsRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRelatedItemsRequest, UpdateRelatedItemsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateReplicationSetResult> updateReplicationSetAsync(UpdateReplicationSetRequest request) {

        return updateReplicationSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateReplicationSetResult> updateReplicationSetAsync(UpdateReplicationSetRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateReplicationSetRequest, UpdateReplicationSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateResponsePlanResult> updateResponsePlanAsync(UpdateResponsePlanRequest request) {

        return updateResponsePlanAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateResponsePlanResult> updateResponsePlanAsync(UpdateResponsePlanRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateResponsePlanRequest, UpdateResponsePlanResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTimelineEventResult> updateTimelineEventAsync(UpdateTimelineEventRequest request) {

        return updateTimelineEventAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTimelineEventResult> updateTimelineEventAsync(UpdateTimelineEventRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTimelineEventRequest, UpdateTimelineEventResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
