/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue;

import javax.annotation.Generated;

import com.amazonaws.services.glue.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSGlue}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGlue implements AWSGlue {

    protected AbstractAWSGlue() {
    }

    @Override
    public BatchCreatePartitionResult batchCreatePartition(BatchCreatePartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteConnectionResult batchDeleteConnection(BatchDeleteConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeletePartitionResult batchDeletePartition(BatchDeletePartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteTableResult batchDeleteTable(BatchDeleteTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteTableVersionResult batchDeleteTableVersion(BatchDeleteTableVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetBlueprintsResult batchGetBlueprints(BatchGetBlueprintsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetCrawlersResult batchGetCrawlers(BatchGetCrawlersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetCustomEntityTypesResult batchGetCustomEntityTypes(BatchGetCustomEntityTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetDevEndpointsResult batchGetDevEndpoints(BatchGetDevEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetJobsResult batchGetJobs(BatchGetJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetPartitionResult batchGetPartition(BatchGetPartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetTriggersResult batchGetTriggers(BatchGetTriggersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetWorkflowsResult batchGetWorkflows(BatchGetWorkflowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchStopJobRunResult batchStopJobRun(BatchStopJobRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdatePartitionResult batchUpdatePartition(BatchUpdatePartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelMLTaskRunResult cancelMLTaskRun(CancelMLTaskRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelStatementResult cancelStatement(CancelStatementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CheckSchemaVersionValidityResult checkSchemaVersionValidity(CheckSchemaVersionValidityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBlueprintResult createBlueprint(CreateBlueprintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateClassifierResult createClassifier(CreateClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectionResult createConnection(CreateConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCrawlerResult createCrawler(CreateCrawlerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCustomEntityTypeResult createCustomEntityType(CreateCustomEntityTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatabaseResult createDatabase(CreateDatabaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDevEndpointResult createDevEndpoint(CreateDevEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMLTransformResult createMLTransform(CreateMLTransformRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePartitionResult createPartition(CreatePartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePartitionIndexResult createPartitionIndex(CreatePartitionIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRegistryResult createRegistry(CreateRegistryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSchemaResult createSchema(CreateSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateScriptResult createScript(CreateScriptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSecurityConfigurationResult createSecurityConfiguration(CreateSecurityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSessionResult createSession(CreateSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTableResult createTable(CreateTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTriggerResult createTrigger(CreateTriggerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserDefinedFunctionResult createUserDefinedFunction(CreateUserDefinedFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkflowResult createWorkflow(CreateWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBlueprintResult deleteBlueprint(DeleteBlueprintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteClassifierResult deleteClassifier(DeleteClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteColumnStatisticsForPartitionResult deleteColumnStatisticsForPartition(DeleteColumnStatisticsForPartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteColumnStatisticsForTableResult deleteColumnStatisticsForTable(DeleteColumnStatisticsForTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectionResult deleteConnection(DeleteConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCrawlerResult deleteCrawler(DeleteCrawlerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCustomEntityTypeResult deleteCustomEntityType(DeleteCustomEntityTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatabaseResult deleteDatabase(DeleteDatabaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDevEndpointResult deleteDevEndpoint(DeleteDevEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteJobResult deleteJob(DeleteJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMLTransformResult deleteMLTransform(DeleteMLTransformRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePartitionResult deletePartition(DeletePartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePartitionIndexResult deletePartitionIndex(DeletePartitionIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRegistryResult deleteRegistry(DeleteRegistryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSchemaResult deleteSchema(DeleteSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSchemaVersionsResult deleteSchemaVersions(DeleteSchemaVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSecurityConfigurationResult deleteSecurityConfiguration(DeleteSecurityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSessionResult deleteSession(DeleteSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTableVersionResult deleteTableVersion(DeleteTableVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTriggerResult deleteTrigger(DeleteTriggerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserDefinedFunctionResult deleteUserDefinedFunction(DeleteUserDefinedFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkflowResult deleteWorkflow(DeleteWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBlueprintResult getBlueprint(GetBlueprintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBlueprintRunResult getBlueprintRun(GetBlueprintRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBlueprintRunsResult getBlueprintRuns(GetBlueprintRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCatalogImportStatusResult getCatalogImportStatus(GetCatalogImportStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetClassifierResult getClassifier(GetClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetClassifiersResult getClassifiers(GetClassifiersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetColumnStatisticsForPartitionResult getColumnStatisticsForPartition(GetColumnStatisticsForPartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetColumnStatisticsForTableResult getColumnStatisticsForTable(GetColumnStatisticsForTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectionResult getConnection(GetConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectionsResult getConnections(GetConnectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCrawlerResult getCrawler(GetCrawlerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCrawlerMetricsResult getCrawlerMetrics(GetCrawlerMetricsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCrawlersResult getCrawlers(GetCrawlersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCustomEntityTypeResult getCustomEntityType(GetCustomEntityTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataCatalogEncryptionSettingsResult getDataCatalogEncryptionSettings(GetDataCatalogEncryptionSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatabaseResult getDatabase(GetDatabaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatabasesResult getDatabases(GetDatabasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataflowGraphResult getDataflowGraph(GetDataflowGraphRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDevEndpointResult getDevEndpoint(GetDevEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDevEndpointsResult getDevEndpoints(GetDevEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobResult getJob(GetJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobBookmarkResult getJobBookmark(GetJobBookmarkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobRunResult getJobRun(GetJobRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobRunsResult getJobRuns(GetJobRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobsResult getJobs(GetJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMLTaskRunResult getMLTaskRun(GetMLTaskRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMLTaskRunsResult getMLTaskRuns(GetMLTaskRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMLTransformResult getMLTransform(GetMLTransformRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMLTransformsResult getMLTransforms(GetMLTransformsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMappingResult getMapping(GetMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPartitionResult getPartition(GetPartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPartitionIndexesResult getPartitionIndexes(GetPartitionIndexesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPartitionsResult getPartitions(GetPartitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPlanResult getPlan(GetPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRegistryResult getRegistry(GetRegistryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourcePoliciesResult getResourcePolicies(GetResourcePoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourcePolicyResult getResourcePolicy(GetResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaResult getSchema(GetSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaByDefinitionResult getSchemaByDefinition(GetSchemaByDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaVersionResult getSchemaVersion(GetSchemaVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaVersionsDiffResult getSchemaVersionsDiff(GetSchemaVersionsDiffRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSecurityConfigurationResult getSecurityConfiguration(GetSecurityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSecurityConfigurationsResult getSecurityConfigurations(GetSecurityConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSessionResult getSession(GetSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStatementResult getStatement(GetStatementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTableResult getTable(GetTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTableVersionResult getTableVersion(GetTableVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTableVersionsResult getTableVersions(GetTableVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTablesResult getTables(GetTablesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTagsResult getTags(GetTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTriggerResult getTrigger(GetTriggerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTriggersResult getTriggers(GetTriggersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUnfilteredPartitionMetadataResult getUnfilteredPartitionMetadata(GetUnfilteredPartitionMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUnfilteredPartitionsMetadataResult getUnfilteredPartitionsMetadata(GetUnfilteredPartitionsMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUnfilteredTableMetadataResult getUnfilteredTableMetadata(GetUnfilteredTableMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserDefinedFunctionResult getUserDefinedFunction(GetUserDefinedFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserDefinedFunctionsResult getUserDefinedFunctions(GetUserDefinedFunctionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowResult getWorkflow(GetWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowRunResult getWorkflowRun(GetWorkflowRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowRunPropertiesResult getWorkflowRunProperties(GetWorkflowRunPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowRunsResult getWorkflowRuns(GetWorkflowRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportCatalogToGlueResult importCatalogToGlue(ImportCatalogToGlueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBlueprintsResult listBlueprints(ListBlueprintsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCrawlersResult listCrawlers(ListCrawlersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCrawlsResult listCrawls(ListCrawlsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCustomEntityTypesResult listCustomEntityTypes(ListCustomEntityTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDevEndpointsResult listDevEndpoints(ListDevEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMLTransformsResult listMLTransforms(ListMLTransformsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRegistriesResult listRegistries(ListRegistriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSchemaVersionsResult listSchemaVersions(ListSchemaVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSchemasResult listSchemas(ListSchemasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSessionsResult listSessions(ListSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStatementsResult listStatements(ListStatementsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTriggersResult listTriggers(ListTriggersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkflowsResult listWorkflows(ListWorkflowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutDataCatalogEncryptionSettingsResult putDataCatalogEncryptionSettings(PutDataCatalogEncryptionSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutSchemaVersionMetadataResult putSchemaVersionMetadata(PutSchemaVersionMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutWorkflowRunPropertiesResult putWorkflowRunProperties(PutWorkflowRunPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public QuerySchemaVersionMetadataResult querySchemaVersionMetadata(QuerySchemaVersionMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterSchemaVersionResult registerSchemaVersion(RegisterSchemaVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveSchemaVersionMetadataResult removeSchemaVersionMetadata(RemoveSchemaVersionMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetJobBookmarkResult resetJobBookmark(ResetJobBookmarkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResumeWorkflowRunResult resumeWorkflowRun(ResumeWorkflowRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RunStatementResult runStatement(RunStatementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchTablesResult searchTables(SearchTablesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartBlueprintRunResult startBlueprintRun(StartBlueprintRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartCrawlerResult startCrawler(StartCrawlerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartCrawlerScheduleResult startCrawlerSchedule(StartCrawlerScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartExportLabelsTaskRunResult startExportLabelsTaskRun(StartExportLabelsTaskRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartImportLabelsTaskRunResult startImportLabelsTaskRun(StartImportLabelsTaskRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartJobRunResult startJobRun(StartJobRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMLEvaluationTaskRunResult startMLEvaluationTaskRun(StartMLEvaluationTaskRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMLLabelingSetGenerationTaskRunResult startMLLabelingSetGenerationTaskRun(StartMLLabelingSetGenerationTaskRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartTriggerResult startTrigger(StartTriggerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartWorkflowRunResult startWorkflowRun(StartWorkflowRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopCrawlerResult stopCrawler(StopCrawlerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopCrawlerScheduleResult stopCrawlerSchedule(StopCrawlerScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopSessionResult stopSession(StopSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTriggerResult stopTrigger(StopTriggerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopWorkflowRunResult stopWorkflowRun(StopWorkflowRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBlueprintResult updateBlueprint(UpdateBlueprintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateClassifierResult updateClassifier(UpdateClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateColumnStatisticsForPartitionResult updateColumnStatisticsForPartition(UpdateColumnStatisticsForPartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateColumnStatisticsForTableResult updateColumnStatisticsForTable(UpdateColumnStatisticsForTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectionResult updateConnection(UpdateConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCrawlerResult updateCrawler(UpdateCrawlerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCrawlerScheduleResult updateCrawlerSchedule(UpdateCrawlerScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatabaseResult updateDatabase(UpdateDatabaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDevEndpointResult updateDevEndpoint(UpdateDevEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateJobResult updateJob(UpdateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMLTransformResult updateMLTransform(UpdateMLTransformRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePartitionResult updatePartition(UpdatePartitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRegistryResult updateRegistry(UpdateRegistryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSchemaResult updateSchema(UpdateSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTableResult updateTable(UpdateTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTriggerResult updateTrigger(UpdateTriggerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserDefinedFunctionResult updateUserDefinedFunction(UpdateUserDefinedFunctionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkflowResult updateWorkflow(UpdateWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
