/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigateway.model.Method;
import java.util.Map;

@SdkInternalApi
public class MethodMarshaller {
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpMethod").build();
    private static final MarshallingInfo<String> AUTHORIZATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationType").build();
    private static final MarshallingInfo<String> AUTHORIZERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerId").build();
    private static final MarshallingInfo<Boolean> APIKEYREQUIRED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeyRequired").build();
    private static final MarshallingInfo<String> OPERATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationName").build();
    private static final MarshallingInfo<Map> REQUESTPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestParameters").build();
    private static final MarshallingInfo<Map> REQUESTMODELS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestModels").build();
    private static final MarshallingInfo<Map> METHODRESPONSES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("methodResponses").build();
    private static final MarshallingInfo<StructuredPojo> METHODINTEGRATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("methodIntegration").build();
    private static final MethodMarshaller instance = new MethodMarshaller();

    public static MethodMarshaller getInstance() {
        return instance;
    }

    public void marshall(Method method, ProtocolMarshaller protocolMarshaller) {
        if (method == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(method.getHttpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall(method.getAuthorizationType(), AUTHORIZATIONTYPE_BINDING);
            protocolMarshaller.marshall(method.getAuthorizerId(), AUTHORIZERID_BINDING);
            protocolMarshaller.marshall(method.getApiKeyRequired(), APIKEYREQUIRED_BINDING);
            protocolMarshaller.marshall(method.getOperationName(), OPERATIONNAME_BINDING);
            protocolMarshaller.marshall(method.getRequestParameters(), REQUESTPARAMETERS_BINDING);
            protocolMarshaller.marshall(method.getRequestModels(), REQUESTMODELS_BINDING);
            protocolMarshaller.marshall(method.getMethodResponses(), METHODRESPONSES_BINDING);
            protocolMarshaller.marshall(method.getMethodIntegration(), METHODINTEGRATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

