/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.Tag;
import com.amazonaws.services.codebuild.model.UpdateProjectRequest;
import com.amazonaws.services.codebuild.model.transform.ProjectArtifactsJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectEnvironmentJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectSourceJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateProjectRequestMarshaller
implements Marshaller<Request<UpdateProjectRequest>, UpdateProjectRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateProjectRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateProjectRequest> marshall(UpdateProjectRequest updateProjectRequest) {
        if (updateProjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateProjectRequest> request = new DefaultRequest<UpdateProjectRequest>(updateProjectRequest, "AWSCodeBuild");
        request.addHeader("X-Amz-Target", "CodeBuild_20161006.UpdateProject");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateProjectRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(updateProjectRequest.getName());
            }
            if (updateProjectRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(updateProjectRequest.getDescription());
            }
            if (updateProjectRequest.getSource() != null) {
                jsonGenerator.writeFieldName("source");
                ProjectSourceJsonMarshaller.getInstance().marshall(updateProjectRequest.getSource(), jsonGenerator);
            }
            if (updateProjectRequest.getArtifacts() != null) {
                jsonGenerator.writeFieldName("artifacts");
                ProjectArtifactsJsonMarshaller.getInstance().marshall(updateProjectRequest.getArtifacts(), jsonGenerator);
            }
            if (updateProjectRequest.getEnvironment() != null) {
                jsonGenerator.writeFieldName("environment");
                ProjectEnvironmentJsonMarshaller.getInstance().marshall(updateProjectRequest.getEnvironment(), jsonGenerator);
            }
            if (updateProjectRequest.getServiceRole() != null) {
                jsonGenerator.writeFieldName("serviceRole").writeValue(updateProjectRequest.getServiceRole());
            }
            if (updateProjectRequest.getTimeoutInMinutes() != null) {
                jsonGenerator.writeFieldName("timeoutInMinutes").writeValue(updateProjectRequest.getTimeoutInMinutes());
            }
            if (updateProjectRequest.getEncryptionKey() != null) {
                jsonGenerator.writeFieldName("encryptionKey").writeValue(updateProjectRequest.getEncryptionKey());
            }
            if ((tagsList = updateProjectRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

