/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servermigration.model.Connector;
import java.util.List;

public class ConnectorJsonMarshaller {
    private static ConnectorJsonMarshaller instance;

    public void marshall(Connector connector, StructuredJsonGenerator jsonGenerator) {
        if (connector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> capabilityListList;
            jsonGenerator.writeStartObject();
            if (connector.getConnectorId() != null) {
                jsonGenerator.writeFieldName("connectorId").writeValue(connector.getConnectorId());
            }
            if (connector.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(connector.getVersion());
            }
            if (connector.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(connector.getStatus());
            }
            if ((capabilityListList = connector.getCapabilityList()) != null) {
                jsonGenerator.writeFieldName("capabilityList");
                jsonGenerator.writeStartArray();
                for (String capabilityListListValue : capabilityListList) {
                    if (capabilityListListValue == null) continue;
                    jsonGenerator.writeValue(capabilityListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (connector.getVmManagerName() != null) {
                jsonGenerator.writeFieldName("vmManagerName").writeValue(connector.getVmManagerName());
            }
            if (connector.getVmManagerType() != null) {
                jsonGenerator.writeFieldName("vmManagerType").writeValue(connector.getVmManagerType());
            }
            if (connector.getVmManagerId() != null) {
                jsonGenerator.writeFieldName("vmManagerId").writeValue(connector.getVmManagerId());
            }
            if (connector.getIpAddress() != null) {
                jsonGenerator.writeFieldName("ipAddress").writeValue(connector.getIpAddress());
            }
            if (connector.getMacAddress() != null) {
                jsonGenerator.writeFieldName("macAddress").writeValue(connector.getMacAddress());
            }
            if (connector.getAssociatedOn() != null) {
                jsonGenerator.writeFieldName("associatedOn").writeValue(connector.getAssociatedOn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConnectorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConnectorJsonMarshaller();
        }
        return instance;
    }
}

