/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceResizePolicy
implements Serializable,
Cloneable {
    private SdkInternalList<String> instancesToTerminate;
    private SdkInternalList<String> instancesToProtect;
    private Integer instanceTerminationTimeout;

    public List<String> getInstancesToTerminate() {
        if (this.instancesToTerminate == null) {
            this.instancesToTerminate = new SdkInternalList();
        }
        return this.instancesToTerminate;
    }

    public void setInstancesToTerminate(Collection<String> instancesToTerminate) {
        if (instancesToTerminate == null) {
            this.instancesToTerminate = null;
            return;
        }
        this.instancesToTerminate = new SdkInternalList<String>(instancesToTerminate);
    }

    public InstanceResizePolicy withInstancesToTerminate(String ... instancesToTerminate) {
        if (this.instancesToTerminate == null) {
            this.setInstancesToTerminate(new SdkInternalList<String>(instancesToTerminate.length));
        }
        for (String ele : instancesToTerminate) {
            this.instancesToTerminate.add(ele);
        }
        return this;
    }

    public InstanceResizePolicy withInstancesToTerminate(Collection<String> instancesToTerminate) {
        this.setInstancesToTerminate(instancesToTerminate);
        return this;
    }

    public List<String> getInstancesToProtect() {
        if (this.instancesToProtect == null) {
            this.instancesToProtect = new SdkInternalList();
        }
        return this.instancesToProtect;
    }

    public void setInstancesToProtect(Collection<String> instancesToProtect) {
        if (instancesToProtect == null) {
            this.instancesToProtect = null;
            return;
        }
        this.instancesToProtect = new SdkInternalList<String>(instancesToProtect);
    }

    public InstanceResizePolicy withInstancesToProtect(String ... instancesToProtect) {
        if (this.instancesToProtect == null) {
            this.setInstancesToProtect(new SdkInternalList<String>(instancesToProtect.length));
        }
        for (String ele : instancesToProtect) {
            this.instancesToProtect.add(ele);
        }
        return this;
    }

    public InstanceResizePolicy withInstancesToProtect(Collection<String> instancesToProtect) {
        this.setInstancesToProtect(instancesToProtect);
        return this;
    }

    public void setInstanceTerminationTimeout(Integer instanceTerminationTimeout) {
        this.instanceTerminationTimeout = instanceTerminationTimeout;
    }

    public Integer getInstanceTerminationTimeout() {
        return this.instanceTerminationTimeout;
    }

    public InstanceResizePolicy withInstanceTerminationTimeout(Integer instanceTerminationTimeout) {
        this.setInstanceTerminationTimeout(instanceTerminationTimeout);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstancesToTerminate() != null) {
            sb.append("InstancesToTerminate: ").append(this.getInstancesToTerminate()).append(",");
        }
        if (this.getInstancesToProtect() != null) {
            sb.append("InstancesToProtect: ").append(this.getInstancesToProtect()).append(",");
        }
        if (this.getInstanceTerminationTimeout() != null) {
            sb.append("InstanceTerminationTimeout: ").append(this.getInstanceTerminationTimeout());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceResizePolicy)) {
            return false;
        }
        InstanceResizePolicy other = (InstanceResizePolicy)obj;
        if (other.getInstancesToTerminate() == null ^ this.getInstancesToTerminate() == null) {
            return false;
        }
        if (other.getInstancesToTerminate() != null && !other.getInstancesToTerminate().equals(this.getInstancesToTerminate())) {
            return false;
        }
        if (other.getInstancesToProtect() == null ^ this.getInstancesToProtect() == null) {
            return false;
        }
        if (other.getInstancesToProtect() != null && !other.getInstancesToProtect().equals(this.getInstancesToProtect())) {
            return false;
        }
        if (other.getInstanceTerminationTimeout() == null ^ this.getInstanceTerminationTimeout() == null) {
            return false;
        }
        return other.getInstanceTerminationTimeout() == null || other.getInstanceTerminationTimeout().equals(this.getInstanceTerminationTimeout());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstancesToTerminate() == null ? 0 : this.getInstancesToTerminate().hashCode());
        hashCode = 31 * hashCode + (this.getInstancesToProtect() == null ? 0 : this.getInstancesToProtect().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTerminationTimeout() == null ? 0 : this.getInstanceTerminationTimeout().hashCode());
        return hashCode;
    }

    public InstanceResizePolicy clone() {
        try {
            return (InstanceResizePolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

