/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.waf.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.DeleteByteMatchSetRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteByteMatchSetRequestMarshaller
implements Marshaller<Request<DeleteByteMatchSetRequest>, DeleteByteMatchSetRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteByteMatchSetRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteByteMatchSetRequest> marshall(DeleteByteMatchSetRequest deleteByteMatchSetRequest) {
        if (deleteByteMatchSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteByteMatchSetRequest> request = new DefaultRequest<DeleteByteMatchSetRequest>(deleteByteMatchSetRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.DeleteByteMatchSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteByteMatchSetRequest.getByteMatchSetId() != null) {
                jsonGenerator.writeFieldName("ByteMatchSetId").writeValue(deleteByteMatchSetRequest.getByteMatchSetId());
            }
            if (deleteByteMatchSetRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(deleteByteMatchSetRequest.getChangeToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

