/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssooidc;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ssooidc.AWSSSOOIDC;
import com.amazonaws.services.ssooidc.AWSSSOOIDCClientBuilder;
import com.amazonaws.services.ssooidc.model.AWSSSOOIDCException;
import com.amazonaws.services.ssooidc.model.CreateTokenRequest;
import com.amazonaws.services.ssooidc.model.CreateTokenResult;
import com.amazonaws.services.ssooidc.model.RegisterClientRequest;
import com.amazonaws.services.ssooidc.model.RegisterClientResult;
import com.amazonaws.services.ssooidc.model.StartDeviceAuthorizationRequest;
import com.amazonaws.services.ssooidc.model.StartDeviceAuthorizationResult;
import com.amazonaws.services.ssooidc.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.AuthorizationPendingExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.CreateTokenRequestProtocolMarshaller;
import com.amazonaws.services.ssooidc.model.transform.CreateTokenResultJsonUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.ExpiredTokenExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.InvalidClientExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.InvalidClientMetadataExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.InvalidGrantExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.InvalidScopeExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.RegisterClientRequestProtocolMarshaller;
import com.amazonaws.services.ssooidc.model.transform.RegisterClientResultJsonUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.SlowDownExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.StartDeviceAuthorizationRequestProtocolMarshaller;
import com.amazonaws.services.ssooidc.model.transform.StartDeviceAuthorizationResultJsonUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.UnauthorizedClientExceptionUnmarshaller;
import com.amazonaws.services.ssooidc.model.transform.UnsupportedGrantTypeExceptionUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSSSOOIDCClient
extends AmazonWebServiceClient
implements AWSSSOOIDC {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSSOOIDC.class);
    private static final String DEFAULT_SIGNING_NAME = "awsssooidc";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SlowDownException").withExceptionUnmarshaller(SlowDownExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredTokenException").withExceptionUnmarshaller(ExpiredTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClientMetadataException").withExceptionUnmarshaller(InvalidClientMetadataExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidGrantException").withExceptionUnmarshaller(InvalidGrantExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedClientException").withExceptionUnmarshaller(UnauthorizedClientExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClientException").withExceptionUnmarshaller(InvalidClientExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AuthorizationPendingException").withExceptionUnmarshaller(AuthorizationPendingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller(InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidScopeException").withExceptionUnmarshaller(InvalidScopeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedGrantTypeException").withExceptionUnmarshaller(UnsupportedGrantTypeExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSSOOIDCException.class));

    public static AWSSSOOIDCClientBuilder builder() {
        return AWSSSOOIDCClientBuilder.standard();
    }

    AWSSSOOIDCClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSSOOIDCClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("oidc");
        this.setEndpoint("oidc.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ssooidc/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ssooidc/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateTokenResult createToken(CreateTokenRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTokenResult executeCreateToken(CreateTokenRequest createTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTokenRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO OIDC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateTokenResultJsonUnmarshaller());
            response = this.anonymousInvoke(request, responseHandler, executionContext);
            CreateTokenResult createTokenResult = (CreateTokenResult)response.getAwsResponse();
            return createTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterClientResult registerClient(RegisterClientRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRegisterClient(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterClientResult executeRegisterClient(RegisterClientRequest registerClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterClientRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(registerClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO OIDC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "RegisterClient");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RegisterClientResultJsonUnmarshaller());
            response = this.anonymousInvoke(request, responseHandler, executionContext);
            RegisterClientResult registerClientResult = (RegisterClientResult)response.getAwsResponse();
            return registerClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDeviceAuthorizationResult startDeviceAuthorization(StartDeviceAuthorizationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartDeviceAuthorization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDeviceAuthorizationResult executeStartDeviceAuthorization(StartDeviceAuthorizationRequest startDeviceAuthorizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDeviceAuthorizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDeviceAuthorizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDeviceAuthorizationRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startDeviceAuthorizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO OIDC");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartDeviceAuthorization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartDeviceAuthorizationResultJsonUnmarshaller());
            response = this.anonymousInvoke(request, responseHandler, executionContext);
            StartDeviceAuthorizationResult startDeviceAuthorizationResult = (StartDeviceAuthorizationResult)response.getAwsResponse();
            return startDeviceAuthorizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

