/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simpleemailv2.model.Destination;
import java.util.List;

@SdkInternalApi
public class DestinationMarshaller {
    private static final MarshallingInfo<List> TOADDRESSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ToAddresses").build();
    private static final MarshallingInfo<List> CCADDRESSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CcAddresses").build();
    private static final MarshallingInfo<List> BCCADDRESSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BccAddresses").build();
    private static final DestinationMarshaller instance = new DestinationMarshaller();

    public static DestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Destination destination, ProtocolMarshaller protocolMarshaller) {
        if (destination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(destination.getToAddresses(), TOADDRESSES_BINDING);
            protocolMarshaller.marshall(destination.getCcAddresses(), CCADDRESSES_BINDING);
            protocolMarshaller.marshall(destination.getBccAddresses(), BCCADDRESSES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

