/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.DailyVolume;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DailyVolumeMarshaller {
    private static final MarshallingInfo<Date> STARTDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> VOLUMESTATISTICS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeStatistics").build();
    private static final MarshallingInfo<List> DOMAINISPPLACEMENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainIspPlacements").build();
    private static final DailyVolumeMarshaller instance = new DailyVolumeMarshaller();

    public static DailyVolumeMarshaller getInstance() {
        return instance;
    }

    public void marshall(DailyVolume dailyVolume, ProtocolMarshaller protocolMarshaller) {
        if (dailyVolume == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dailyVolume.getStartDate(), STARTDATE_BINDING);
            protocolMarshaller.marshall(dailyVolume.getVolumeStatistics(), VOLUMESTATISTICS_BINDING);
            protocolMarshaller.marshall(dailyVolume.getDomainIspPlacements(), DOMAINISPPLACEMENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

