/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemas.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.schemas.model.SchemaSummary;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class SchemaSummaryMarshaller {
    private static final MarshallingInfo<Date> LASTMODIFIED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> SCHEMAARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaArn").build();
    private static final MarshallingInfo<String> SCHEMANAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaName").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<Long> VERSIONCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionCount").build();
    private static final SchemaSummaryMarshaller instance = new SchemaSummaryMarshaller();

    public static SchemaSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(SchemaSummary schemaSummary, ProtocolMarshaller protocolMarshaller) {
        if (schemaSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(schemaSummary.getLastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall(schemaSummary.getSchemaArn(), SCHEMAARN_BINDING);
            protocolMarshaller.marshall(schemaSummary.getSchemaName(), SCHEMANAME_BINDING);
            protocolMarshaller.marshall(schemaSummary.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(schemaSummary.getVersionCount(), VERSIONCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

