/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemas;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.schemas.AWSSchemas;
import com.amazonaws.services.schemas.AWSSchemasClientBuilder;
import com.amazonaws.services.schemas.model.AWSSchemasException;
import com.amazonaws.services.schemas.model.CreateDiscovererRequest;
import com.amazonaws.services.schemas.model.CreateDiscovererResult;
import com.amazonaws.services.schemas.model.CreateRegistryRequest;
import com.amazonaws.services.schemas.model.CreateRegistryResult;
import com.amazonaws.services.schemas.model.CreateSchemaRequest;
import com.amazonaws.services.schemas.model.CreateSchemaResult;
import com.amazonaws.services.schemas.model.DeleteDiscovererRequest;
import com.amazonaws.services.schemas.model.DeleteDiscovererResult;
import com.amazonaws.services.schemas.model.DeleteRegistryRequest;
import com.amazonaws.services.schemas.model.DeleteRegistryResult;
import com.amazonaws.services.schemas.model.DeleteSchemaRequest;
import com.amazonaws.services.schemas.model.DeleteSchemaResult;
import com.amazonaws.services.schemas.model.DeleteSchemaVersionRequest;
import com.amazonaws.services.schemas.model.DeleteSchemaVersionResult;
import com.amazonaws.services.schemas.model.DescribeCodeBindingRequest;
import com.amazonaws.services.schemas.model.DescribeCodeBindingResult;
import com.amazonaws.services.schemas.model.DescribeDiscovererRequest;
import com.amazonaws.services.schemas.model.DescribeDiscovererResult;
import com.amazonaws.services.schemas.model.DescribeRegistryRequest;
import com.amazonaws.services.schemas.model.DescribeRegistryResult;
import com.amazonaws.services.schemas.model.DescribeSchemaRequest;
import com.amazonaws.services.schemas.model.DescribeSchemaResult;
import com.amazonaws.services.schemas.model.GetCodeBindingSourceRequest;
import com.amazonaws.services.schemas.model.GetCodeBindingSourceResult;
import com.amazonaws.services.schemas.model.GetDiscoveredSchemaRequest;
import com.amazonaws.services.schemas.model.GetDiscoveredSchemaResult;
import com.amazonaws.services.schemas.model.ListDiscoverersRequest;
import com.amazonaws.services.schemas.model.ListDiscoverersResult;
import com.amazonaws.services.schemas.model.ListRegistriesRequest;
import com.amazonaws.services.schemas.model.ListRegistriesResult;
import com.amazonaws.services.schemas.model.ListSchemaVersionsRequest;
import com.amazonaws.services.schemas.model.ListSchemaVersionsResult;
import com.amazonaws.services.schemas.model.ListSchemasRequest;
import com.amazonaws.services.schemas.model.ListSchemasResult;
import com.amazonaws.services.schemas.model.ListTagsForResourceRequest;
import com.amazonaws.services.schemas.model.ListTagsForResourceResult;
import com.amazonaws.services.schemas.model.LockServiceLinkedRoleRequest;
import com.amazonaws.services.schemas.model.LockServiceLinkedRoleResult;
import com.amazonaws.services.schemas.model.PutCodeBindingRequest;
import com.amazonaws.services.schemas.model.PutCodeBindingResult;
import com.amazonaws.services.schemas.model.SearchSchemasRequest;
import com.amazonaws.services.schemas.model.SearchSchemasResult;
import com.amazonaws.services.schemas.model.StartDiscovererRequest;
import com.amazonaws.services.schemas.model.StartDiscovererResult;
import com.amazonaws.services.schemas.model.StopDiscovererRequest;
import com.amazonaws.services.schemas.model.StopDiscovererResult;
import com.amazonaws.services.schemas.model.TagResourceRequest;
import com.amazonaws.services.schemas.model.TagResourceResult;
import com.amazonaws.services.schemas.model.UnlockServiceLinkedRoleRequest;
import com.amazonaws.services.schemas.model.UnlockServiceLinkedRoleResult;
import com.amazonaws.services.schemas.model.UntagResourceRequest;
import com.amazonaws.services.schemas.model.UntagResourceResult;
import com.amazonaws.services.schemas.model.UpdateDiscovererRequest;
import com.amazonaws.services.schemas.model.UpdateDiscovererResult;
import com.amazonaws.services.schemas.model.UpdateRegistryRequest;
import com.amazonaws.services.schemas.model.UpdateRegistryResult;
import com.amazonaws.services.schemas.model.UpdateSchemaRequest;
import com.amazonaws.services.schemas.model.UpdateSchemaResult;
import com.amazonaws.services.schemas.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.CreateDiscovererRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.CreateDiscovererResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.CreateRegistryRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.CreateRegistryResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.CreateSchemaRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.CreateSchemaResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.DeleteDiscovererRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.DeleteDiscovererResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.DeleteRegistryRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.DeleteRegistryResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.DeleteSchemaRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.DeleteSchemaResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.DeleteSchemaVersionRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.DeleteSchemaVersionResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.DescribeCodeBindingRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.DescribeCodeBindingResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.DescribeDiscovererRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.DescribeDiscovererResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.DescribeRegistryRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.DescribeRegistryResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.DescribeSchemaRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.DescribeSchemaResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.GetCodeBindingSourceRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.GetCodeBindingSourceResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.GetDiscoveredSchemaRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.GetDiscoveredSchemaResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.GoneExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.ListDiscoverersRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.ListDiscoverersResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.ListRegistriesRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.ListRegistriesResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.ListSchemaVersionsRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.ListSchemaVersionsResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.ListSchemasRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.ListSchemasResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.LockServiceLinkedRoleRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.LockServiceLinkedRoleResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.PutCodeBindingRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.PutCodeBindingResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.SearchSchemasRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.SearchSchemasResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.StartDiscovererRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.StartDiscovererResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.StopDiscovererRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.StopDiscovererResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.UnauthorizedExceptionUnmarshaller;
import com.amazonaws.services.schemas.model.transform.UnlockServiceLinkedRoleRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.UnlockServiceLinkedRoleResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.UpdateDiscovererRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.UpdateDiscovererResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.UpdateRegistryRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.UpdateRegistryResultJsonUnmarshaller;
import com.amazonaws.services.schemas.model.transform.UpdateSchemaRequestProtocolMarshaller;
import com.amazonaws.services.schemas.model.transform.UpdateSchemaResultJsonUnmarshaller;
import com.amazonaws.services.schemas.waiters.AWSSchemasWaiters;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSSchemasClient
extends AmazonWebServiceClient
implements AWSSchemas {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSchemas.class);
    private static final String DEFAULT_SIGNING_NAME = "schemas";
    private volatile AWSSchemasWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GoneException").withExceptionUnmarshaller(GoneExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller(NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller(ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withExceptionUnmarshaller(UnauthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller(ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller(TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller(BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withExceptionUnmarshaller(InternalServerErrorExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSchemasException.class));

    public static AWSSchemasClientBuilder builder() {
        return AWSSchemasClientBuilder.standard();
    }

    AWSSchemasClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSchemasClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("schemas.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/schemas/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/schemas/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDiscovererResult createDiscoverer(CreateDiscovererRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateDiscoverer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDiscovererResult executeCreateDiscoverer(CreateDiscovererRequest createDiscovererRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDiscovererRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDiscovererRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDiscovererRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createDiscovererRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateDiscoverer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateDiscovererResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDiscovererResult createDiscovererResult = (CreateDiscovererResult)response.getAwsResponse();
            return createDiscovererResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRegistryResult createRegistry(CreateRegistryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateRegistry(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRegistryResult executeCreateRegistry(CreateRegistryRequest createRegistryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRegistryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRegistryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRegistryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createRegistryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateRegistry");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateRegistryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRegistryResult createRegistryResult = (CreateRegistryResult)response.getAwsResponse();
            return createRegistryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSchemaResult createSchema(CreateSchemaRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSchemaResult executeCreateSchema(CreateSchemaRequest createSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSchemaRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateSchema");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSchemaResult createSchemaResult = (CreateSchemaResult)response.getAwsResponse();
            return createSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDiscovererResult deleteDiscoverer(DeleteDiscovererRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteDiscoverer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDiscovererResult executeDeleteDiscoverer(DeleteDiscovererRequest deleteDiscovererRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDiscovererRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDiscovererRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDiscovererRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteDiscovererRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteDiscoverer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteDiscovererResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDiscovererResult deleteDiscovererResult = (DeleteDiscovererResult)response.getAwsResponse();
            return deleteDiscovererResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRegistryResult deleteRegistry(DeleteRegistryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteRegistry(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRegistryResult executeDeleteRegistry(DeleteRegistryRequest deleteRegistryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRegistryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRegistryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRegistryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteRegistryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteRegistry");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteRegistryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRegistryResult deleteRegistryResult = (DeleteRegistryResult)response.getAwsResponse();
            return deleteRegistryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSchemaResult deleteSchema(DeleteSchemaRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSchemaResult executeDeleteSchema(DeleteSchemaRequest deleteSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSchemaRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteSchema");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSchemaResult deleteSchemaResult = (DeleteSchemaResult)response.getAwsResponse();
            return deleteSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSchemaVersionResult deleteSchemaVersion(DeleteSchemaVersionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteSchemaVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSchemaVersionResult executeDeleteSchemaVersion(DeleteSchemaVersionRequest deleteSchemaVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSchemaVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSchemaVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSchemaVersionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteSchemaVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteSchemaVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteSchemaVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSchemaVersionResult deleteSchemaVersionResult = (DeleteSchemaVersionResult)response.getAwsResponse();
            return deleteSchemaVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCodeBindingResult describeCodeBinding(DescribeCodeBindingRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeCodeBinding(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCodeBindingResult executeDescribeCodeBinding(DescribeCodeBindingRequest describeCodeBindingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCodeBindingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCodeBindingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCodeBindingRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeCodeBindingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeCodeBinding");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeCodeBindingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCodeBindingResult describeCodeBindingResult = (DescribeCodeBindingResult)response.getAwsResponse();
            return describeCodeBindingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDiscovererResult describeDiscoverer(DescribeDiscovererRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeDiscoverer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDiscovererResult executeDescribeDiscoverer(DescribeDiscovererRequest describeDiscovererRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDiscovererRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDiscovererRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDiscovererRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeDiscovererRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeDiscoverer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeDiscovererResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDiscovererResult describeDiscovererResult = (DescribeDiscovererResult)response.getAwsResponse();
            return describeDiscovererResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRegistryResult describeRegistry(DescribeRegistryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeRegistry(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRegistryResult executeDescribeRegistry(DescribeRegistryRequest describeRegistryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRegistryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRegistryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRegistryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeRegistryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeRegistry");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeRegistryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRegistryResult describeRegistryResult = (DescribeRegistryResult)response.getAwsResponse();
            return describeRegistryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSchemaResult describeSchema(DescribeSchemaRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSchemaResult executeDescribeSchema(DescribeSchemaRequest describeSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSchemaRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeSchema");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSchemaResult describeSchemaResult = (DescribeSchemaResult)response.getAwsResponse();
            return describeSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCodeBindingSourceResult getCodeBindingSource(GetCodeBindingSourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetCodeBindingSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCodeBindingSourceResult executeGetCodeBindingSource(GetCodeBindingSourceRequest getCodeBindingSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCodeBindingSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCodeBindingSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCodeBindingSourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getCodeBindingSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetCodeBindingSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), new GetCodeBindingSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCodeBindingSourceResult getCodeBindingSourceResult = (GetCodeBindingSourceResult)response.getAwsResponse();
            return getCodeBindingSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDiscoveredSchemaResult getDiscoveredSchema(GetDiscoveredSchemaRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDiscoveredSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDiscoveredSchemaResult executeGetDiscoveredSchema(GetDiscoveredSchemaRequest getDiscoveredSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDiscoveredSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDiscoveredSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDiscoveredSchemaRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDiscoveredSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetDiscoveredSchema");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDiscoveredSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDiscoveredSchemaResult getDiscoveredSchemaResult = (GetDiscoveredSchemaResult)response.getAwsResponse();
            return getDiscoveredSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDiscoverersResult listDiscoverers(ListDiscoverersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDiscoverers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDiscoverersResult executeListDiscoverers(ListDiscoverersRequest listDiscoverersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDiscoverersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDiscoverersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDiscoverersRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listDiscoverersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListDiscoverers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListDiscoverersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDiscoverersResult listDiscoverersResult = (ListDiscoverersResult)response.getAwsResponse();
            return listDiscoverersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRegistriesResult listRegistries(ListRegistriesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRegistries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRegistriesResult executeListRegistries(ListRegistriesRequest listRegistriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRegistriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRegistriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRegistriesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listRegistriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListRegistries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRegistriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRegistriesResult listRegistriesResult = (ListRegistriesResult)response.getAwsResponse();
            return listRegistriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSchemaVersionsResult listSchemaVersions(ListSchemaVersionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListSchemaVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSchemaVersionsResult executeListSchemaVersions(ListSchemaVersionsRequest listSchemaVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSchemaVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSchemaVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSchemaVersionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listSchemaVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListSchemaVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListSchemaVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSchemaVersionsResult listSchemaVersionsResult = (ListSchemaVersionsResult)response.getAwsResponse();
            return listSchemaVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSchemasResult listSchemas(ListSchemasRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListSchemas(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSchemasResult executeListSchemas(ListSchemasRequest listSchemasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSchemasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSchemasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSchemasRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listSchemasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListSchemas");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListSchemasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSchemasResult listSchemasResult = (ListSchemasResult)response.getAwsResponse();
            return listSchemasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public LockServiceLinkedRoleResult lockServiceLinkedRole(LockServiceLinkedRoleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeLockServiceLinkedRole(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final LockServiceLinkedRoleResult executeLockServiceLinkedRole(LockServiceLinkedRoleRequest lockServiceLinkedRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(lockServiceLinkedRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<LockServiceLinkedRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new LockServiceLinkedRoleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(lockServiceLinkedRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "LockServiceLinkedRole");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new LockServiceLinkedRoleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            LockServiceLinkedRoleResult lockServiceLinkedRoleResult = (LockServiceLinkedRoleResult)response.getAwsResponse();
            return lockServiceLinkedRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutCodeBindingResult putCodeBinding(PutCodeBindingRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutCodeBinding(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutCodeBindingResult executePutCodeBinding(PutCodeBindingRequest putCodeBindingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putCodeBindingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutCodeBindingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutCodeBindingRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putCodeBindingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutCodeBinding");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutCodeBindingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutCodeBindingResult putCodeBindingResult = (PutCodeBindingResult)response.getAwsResponse();
            return putCodeBindingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SearchSchemasResult searchSchemas(SearchSchemasRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSearchSchemas(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SearchSchemasResult executeSearchSchemas(SearchSchemasRequest searchSchemasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchSchemasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchSchemasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchSchemasRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(searchSchemasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "SearchSchemas");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SearchSchemasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SearchSchemasResult searchSchemasResult = (SearchSchemasResult)response.getAwsResponse();
            return searchSchemasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDiscovererResult startDiscoverer(StartDiscovererRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartDiscoverer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDiscovererResult executeStartDiscoverer(StartDiscovererRequest startDiscovererRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDiscovererRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDiscovererRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDiscovererRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startDiscovererRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartDiscoverer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartDiscovererResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDiscovererResult startDiscovererResult = (StartDiscovererResult)response.getAwsResponse();
            return startDiscovererResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopDiscovererResult stopDiscoverer(StopDiscovererRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStopDiscoverer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopDiscovererResult executeStopDiscoverer(StopDiscovererRequest stopDiscovererRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopDiscovererRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopDiscovererRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopDiscovererRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(stopDiscovererRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StopDiscoverer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopDiscovererResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopDiscovererResult stopDiscovererResult = (StopDiscovererResult)response.getAwsResponse();
            return stopDiscovererResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UnlockServiceLinkedRoleResult unlockServiceLinkedRole(UnlockServiceLinkedRoleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUnlockServiceLinkedRole(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UnlockServiceLinkedRoleResult executeUnlockServiceLinkedRole(UnlockServiceLinkedRoleRequest unlockServiceLinkedRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unlockServiceLinkedRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnlockServiceLinkedRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnlockServiceLinkedRoleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(unlockServiceLinkedRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UnlockServiceLinkedRole");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UnlockServiceLinkedRoleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UnlockServiceLinkedRoleResult unlockServiceLinkedRoleResult = (UnlockServiceLinkedRoleResult)response.getAwsResponse();
            return unlockServiceLinkedRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDiscovererResult updateDiscoverer(UpdateDiscovererRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateDiscoverer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDiscovererResult executeUpdateDiscoverer(UpdateDiscovererRequest updateDiscovererRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDiscovererRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDiscovererRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDiscovererRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateDiscovererRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateDiscoverer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateDiscovererResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDiscovererResult updateDiscovererResult = (UpdateDiscovererResult)response.getAwsResponse();
            return updateDiscovererResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRegistryResult updateRegistry(UpdateRegistryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateRegistry(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRegistryResult executeUpdateRegistry(UpdateRegistryRequest updateRegistryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRegistryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRegistryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRegistryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateRegistryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateRegistry");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRegistryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRegistryResult updateRegistryResult = (UpdateRegistryResult)response.getAwsResponse();
            return updateRegistryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSchemaResult updateSchema(UpdateSchemaRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSchemaResult executeUpdateSchema(UpdateSchemaRequest updateSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSchemaRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateSchema");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSchemaResult updateSchemaResult = (UpdateSchemaResult)response.getAwsResponse();
            return updateSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSSchemasWaiters waiters() {
        if (this.waiters == null) {
            AWSSchemasClient aWSSchemasClient = this;
            synchronized (aWSSchemasClient) {
                if (this.waiters == null) {
                    this.waiters = new AWSSchemasWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

