/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.qldb.model.S3EncryptionConfiguration;

@SdkInternalApi
public class S3EncryptionConfigurationMarshaller {
    private static final MarshallingInfo<String> OBJECTENCRYPTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectEncryptionType").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyArn").build();
    private static final S3EncryptionConfigurationMarshaller instance = new S3EncryptionConfigurationMarshaller();

    public static S3EncryptionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3EncryptionConfiguration s3EncryptionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (s3EncryptionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3EncryptionConfiguration.getObjectEncryptionType(), OBJECTENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall(s3EncryptionConfiguration.getKmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

