/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.Sort;

@SdkInternalApi
public class SortMarshaller {
    private static final MarshallingInfo<String> SORTBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortBy").build();
    private static final MarshallingInfo<String> SORTORDER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortOrder").build();
    private static final SortMarshaller instance = new SortMarshaller();

    public static SortMarshaller getInstance() {
        return instance;
    }

    public void marshall(Sort sort, ProtocolMarshaller protocolMarshaller) {
        if (sort == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sort.getSortBy(), SORTBY_BINDING);
            protocolMarshaller.marshall(sort.getSortOrder(), SORTORDER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

