/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.Entity;

@SdkInternalApi
public class EntityMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> IDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Identifier").build();
    private static final EntityMarshaller instance = new EntityMarshaller();

    public static EntityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Entity entity, ProtocolMarshaller protocolMarshaller) {
        if (entity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(entity.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(entity.getIdentifier(), IDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

