/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.marketplacecatalog.model.Filter;
import com.amazonaws.services.marketplacecatalog.model.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListChangeSetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalog;
    private List<Filter> filterList;
    private Sort sort;
    private Integer maxResults;
    private String nextToken;

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public ListChangeSetsRequest withCatalog(String catalog) {
        this.setCatalog(catalog);
        return this;
    }

    public List<Filter> getFilterList() {
        return this.filterList;
    }

    public void setFilterList(Collection<Filter> filterList) {
        if (filterList == null) {
            this.filterList = null;
            return;
        }
        this.filterList = new ArrayList<Filter>(filterList);
    }

    public ListChangeSetsRequest withFilterList(Filter ... filterList) {
        if (this.filterList == null) {
            this.setFilterList(new ArrayList<Filter>(filterList.length));
        }
        for (Filter ele : filterList) {
            this.filterList.add(ele);
        }
        return this;
    }

    public ListChangeSetsRequest withFilterList(Collection<Filter> filterList) {
        this.setFilterList(filterList);
        return this;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public Sort getSort() {
        return this.sort;
    }

    public ListChangeSetsRequest withSort(Sort sort) {
        this.setSort(sort);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListChangeSetsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListChangeSetsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalog() != null) {
            sb.append("Catalog: ").append(this.getCatalog()).append(",");
        }
        if (this.getFilterList() != null) {
            sb.append("FilterList: ").append(this.getFilterList()).append(",");
        }
        if (this.getSort() != null) {
            sb.append("Sort: ").append(this.getSort()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangeSetsRequest)) {
            return false;
        }
        ListChangeSetsRequest other = (ListChangeSetsRequest)obj;
        if (other.getCatalog() == null ^ this.getCatalog() == null) {
            return false;
        }
        if (other.getCatalog() != null && !other.getCatalog().equals(this.getCatalog())) {
            return false;
        }
        if (other.getFilterList() == null ^ this.getFilterList() == null) {
            return false;
        }
        if (other.getFilterList() != null && !other.getFilterList().equals(this.getFilterList())) {
            return false;
        }
        if (other.getSort() == null ^ this.getSort() == null) {
            return false;
        }
        if (other.getSort() != null && !other.getSort().equals(this.getSort())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalog() == null ? 0 : this.getCatalog().hashCode());
        hashCode = 31 * hashCode + (this.getFilterList() == null ? 0 : this.getFilterList().hashCode());
        hashCode = 31 * hashCode + (this.getSort() == null ? 0 : this.getSort().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListChangeSetsRequest clone() {
        return (ListChangeSetsRequest)super.clone();
    }
}

