/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideosignalingchannels.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.IceServerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IceServer
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> uris;
    private String username;
    private String password;
    private Integer ttl;

    public List<String> getUris() {
        return this.uris;
    }

    public void setUris(Collection<String> uris) {
        if (uris == null) {
            this.uris = null;
            return;
        }
        this.uris = new ArrayList<String>(uris);
    }

    public IceServer withUris(String ... uris) {
        if (this.uris == null) {
            this.setUris(new ArrayList<String>(uris.length));
        }
        for (String ele : uris) {
            this.uris.add(ele);
        }
        return this;
    }

    public IceServer withUris(Collection<String> uris) {
        this.setUris(uris);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public IceServer withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public IceServer withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public IceServer withTtl(Integer ttl) {
        this.setTtl(ttl);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUris() != null) {
            sb.append("Uris: ").append(this.getUris()).append(",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: ").append(this.getPassword()).append(",");
        }
        if (this.getTtl() != null) {
            sb.append("Ttl: ").append(this.getTtl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IceServer)) {
            return false;
        }
        IceServer other = (IceServer)obj;
        if (other.getUris() == null ^ this.getUris() == null) {
            return false;
        }
        if (other.getUris() != null && !other.getUris().equals(this.getUris())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getTtl() == null ^ this.getTtl() == null) {
            return false;
        }
        return other.getTtl() == null || other.getTtl().equals(this.getTtl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUris() == null ? 0 : this.getUris().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getTtl() == null ? 0 : this.getTtl().hashCode());
        return hashCode;
    }

    public IceServer clone() {
        try {
            return (IceServer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IceServerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

