/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.QueryRequest;
import java.util.List;

@SdkInternalApi
public class QueryRequestMarshaller {
    private static final MarshallingInfo<String> INDEXID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexId").build();
    private static final MarshallingInfo<String> QUERYTEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryText").build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeFilter").build();
    private static final MarshallingInfo<List> FACETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Facets").build();
    private static final MarshallingInfo<List> REQUESTEDDOCUMENTATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedDocumentAttributes").build();
    private static final MarshallingInfo<String> QUERYRESULTTYPEFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryResultTypeFilter").build();
    private static final MarshallingInfo<Integer> PAGENUMBER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageNumber").build();
    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").build();
    private static final QueryRequestMarshaller instance = new QueryRequestMarshaller();

    public static QueryRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(QueryRequest queryRequest, ProtocolMarshaller protocolMarshaller) {
        if (queryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(queryRequest.getIndexId(), INDEXID_BINDING);
            protocolMarshaller.marshall(queryRequest.getQueryText(), QUERYTEXT_BINDING);
            protocolMarshaller.marshall(queryRequest.getAttributeFilter(), ATTRIBUTEFILTER_BINDING);
            protocolMarshaller.marshall(queryRequest.getFacets(), FACETS_BINDING);
            protocolMarshaller.marshall(queryRequest.getRequestedDocumentAttributes(), REQUESTEDDOCUMENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(queryRequest.getQueryResultTypeFilter(), QUERYRESULTTYPEFILTER_BINDING);
            protocolMarshaller.marshall(queryRequest.getPageNumber(), PAGENUMBER_BINDING);
            protocolMarshaller.marshall(queryRequest.getPageSize(), PAGESIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

