/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kendra.model.ConnectionConfiguration;

@SdkInternalApi
public class ConnectionConfigurationMarshaller {
    private static final MarshallingInfo<String> DATABASEHOST_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseHost").build();
    private static final MarshallingInfo<Integer> DATABASEPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabasePort").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretArn").build();
    private static final ConnectionConfigurationMarshaller instance = new ConnectionConfigurationMarshaller();

    public static ConnectionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConnectionConfiguration connectionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (connectionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(connectionConfiguration.getDatabaseHost(), DATABASEHOST_BINDING);
            protocolMarshaller.marshall(connectionConfiguration.getDatabasePort(), DATABASEPORT_BINDING);
            protocolMarshaller.marshall(connectionConfiguration.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall(connectionConfiguration.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(connectionConfiguration.getSecretArn(), SECRETARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

