/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.PrincipalType;
import com.amazonaws.services.kendra.model.ReadAccessType;
import com.amazonaws.services.kendra.model.transform.PrincipalMarshaller;
import java.io.Serializable;

public class Principal
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String type;
    private String access;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Principal withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Principal withType(String type) {
        this.setType(type);
        return this;
    }

    public Principal withType(PrincipalType type) {
        this.type = type.toString();
        return this;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getAccess() {
        return this.access;
    }

    public Principal withAccess(String access) {
        this.setAccess(access);
        return this;
    }

    public Principal withAccess(ReadAccessType access) {
        this.access = access.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getAccess() != null) {
            sb.append("Access: ").append(this.getAccess());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getAccess() == null ^ this.getAccess() == null) {
            return false;
        }
        return other.getAccess() == null || other.getAccess().equals(this.getAccess());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getAccess() == null ? 0 : this.getAccess().hashCode());
        return hashCode;
    }

    public Principal clone() {
        try {
            return (Principal)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrincipalMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

