/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DatabaseConfiguration;
import com.amazonaws.services.kendra.model.S3DataSourceConfiguration;
import com.amazonaws.services.kendra.model.SharePointConfiguration;
import com.amazonaws.services.kendra.model.transform.DataSourceConfigurationMarshaller;
import java.io.Serializable;

public class DataSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private S3DataSourceConfiguration s3Configuration;
    private SharePointConfiguration sharePointConfiguration;
    private DatabaseConfiguration databaseConfiguration;

    public void setS3Configuration(S3DataSourceConfiguration s3Configuration) {
        this.s3Configuration = s3Configuration;
    }

    public S3DataSourceConfiguration getS3Configuration() {
        return this.s3Configuration;
    }

    public DataSourceConfiguration withS3Configuration(S3DataSourceConfiguration s3Configuration) {
        this.setS3Configuration(s3Configuration);
        return this;
    }

    public void setSharePointConfiguration(SharePointConfiguration sharePointConfiguration) {
        this.sharePointConfiguration = sharePointConfiguration;
    }

    public SharePointConfiguration getSharePointConfiguration() {
        return this.sharePointConfiguration;
    }

    public DataSourceConfiguration withSharePointConfiguration(SharePointConfiguration sharePointConfiguration) {
        this.setSharePointConfiguration(sharePointConfiguration);
        return this;
    }

    public void setDatabaseConfiguration(DatabaseConfiguration databaseConfiguration) {
        this.databaseConfiguration = databaseConfiguration;
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.databaseConfiguration;
    }

    public DataSourceConfiguration withDatabaseConfiguration(DatabaseConfiguration databaseConfiguration) {
        this.setDatabaseConfiguration(databaseConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Configuration() != null) {
            sb.append("S3Configuration: ").append(this.getS3Configuration()).append(",");
        }
        if (this.getSharePointConfiguration() != null) {
            sb.append("SharePointConfiguration: ").append(this.getSharePointConfiguration()).append(",");
        }
        if (this.getDatabaseConfiguration() != null) {
            sb.append("DatabaseConfiguration: ").append(this.getDatabaseConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration)obj;
        if (other.getS3Configuration() == null ^ this.getS3Configuration() == null) {
            return false;
        }
        if (other.getS3Configuration() != null && !other.getS3Configuration().equals(this.getS3Configuration())) {
            return false;
        }
        if (other.getSharePointConfiguration() == null ^ this.getSharePointConfiguration() == null) {
            return false;
        }
        if (other.getSharePointConfiguration() != null && !other.getSharePointConfiguration().equals(this.getSharePointConfiguration())) {
            return false;
        }
        if (other.getDatabaseConfiguration() == null ^ this.getDatabaseConfiguration() == null) {
            return false;
        }
        return other.getDatabaseConfiguration() == null || other.getDatabaseConfiguration().equals(this.getDatabaseConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Configuration() == null ? 0 : this.getS3Configuration().hashCode());
        hashCode = 31 * hashCode + (this.getSharePointConfiguration() == null ? 0 : this.getSharePointConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseConfiguration() == null ? 0 : this.getDatabaseConfiguration().hashCode());
        return hashCode;
    }

    public DataSourceConfiguration clone() {
        try {
            return (DataSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

