/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.transform.ColumnConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColumnConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String documentIdColumnName;
    private String documentDataColumnName;
    private String documentTitleColumnName;
    private List<DataSourceToIndexFieldMapping> fieldMappings;
    private List<String> changeDetectingColumns;

    public void setDocumentIdColumnName(String documentIdColumnName) {
        this.documentIdColumnName = documentIdColumnName;
    }

    public String getDocumentIdColumnName() {
        return this.documentIdColumnName;
    }

    public ColumnConfiguration withDocumentIdColumnName(String documentIdColumnName) {
        this.setDocumentIdColumnName(documentIdColumnName);
        return this;
    }

    public void setDocumentDataColumnName(String documentDataColumnName) {
        this.documentDataColumnName = documentDataColumnName;
    }

    public String getDocumentDataColumnName() {
        return this.documentDataColumnName;
    }

    public ColumnConfiguration withDocumentDataColumnName(String documentDataColumnName) {
        this.setDocumentDataColumnName(documentDataColumnName);
        return this;
    }

    public void setDocumentTitleColumnName(String documentTitleColumnName) {
        this.documentTitleColumnName = documentTitleColumnName;
    }

    public String getDocumentTitleColumnName() {
        return this.documentTitleColumnName;
    }

    public ColumnConfiguration withDocumentTitleColumnName(String documentTitleColumnName) {
        this.setDocumentTitleColumnName(documentTitleColumnName);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public ColumnConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public ColumnConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public List<String> getChangeDetectingColumns() {
        return this.changeDetectingColumns;
    }

    public void setChangeDetectingColumns(Collection<String> changeDetectingColumns) {
        if (changeDetectingColumns == null) {
            this.changeDetectingColumns = null;
            return;
        }
        this.changeDetectingColumns = new ArrayList<String>(changeDetectingColumns);
    }

    public ColumnConfiguration withChangeDetectingColumns(String ... changeDetectingColumns) {
        if (this.changeDetectingColumns == null) {
            this.setChangeDetectingColumns(new ArrayList<String>(changeDetectingColumns.length));
        }
        for (String ele : changeDetectingColumns) {
            this.changeDetectingColumns.add(ele);
        }
        return this;
    }

    public ColumnConfiguration withChangeDetectingColumns(Collection<String> changeDetectingColumns) {
        this.setChangeDetectingColumns(changeDetectingColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentIdColumnName() != null) {
            sb.append("DocumentIdColumnName: ").append(this.getDocumentIdColumnName()).append(",");
        }
        if (this.getDocumentDataColumnName() != null) {
            sb.append("DocumentDataColumnName: ").append(this.getDocumentDataColumnName()).append(",");
        }
        if (this.getDocumentTitleColumnName() != null) {
            sb.append("DocumentTitleColumnName: ").append(this.getDocumentTitleColumnName()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings()).append(",");
        }
        if (this.getChangeDetectingColumns() != null) {
            sb.append("ChangeDetectingColumns: ").append(this.getChangeDetectingColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnConfiguration)) {
            return false;
        }
        ColumnConfiguration other = (ColumnConfiguration)obj;
        if (other.getDocumentIdColumnName() == null ^ this.getDocumentIdColumnName() == null) {
            return false;
        }
        if (other.getDocumentIdColumnName() != null && !other.getDocumentIdColumnName().equals(this.getDocumentIdColumnName())) {
            return false;
        }
        if (other.getDocumentDataColumnName() == null ^ this.getDocumentDataColumnName() == null) {
            return false;
        }
        if (other.getDocumentDataColumnName() != null && !other.getDocumentDataColumnName().equals(this.getDocumentDataColumnName())) {
            return false;
        }
        if (other.getDocumentTitleColumnName() == null ^ this.getDocumentTitleColumnName() == null) {
            return false;
        }
        if (other.getDocumentTitleColumnName() != null && !other.getDocumentTitleColumnName().equals(this.getDocumentTitleColumnName())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        if (other.getFieldMappings() != null && !other.getFieldMappings().equals(this.getFieldMappings())) {
            return false;
        }
        if (other.getChangeDetectingColumns() == null ^ this.getChangeDetectingColumns() == null) {
            return false;
        }
        return other.getChangeDetectingColumns() == null || other.getChangeDetectingColumns().equals(this.getChangeDetectingColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentIdColumnName() == null ? 0 : this.getDocumentIdColumnName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentDataColumnName() == null ? 0 : this.getDocumentDataColumnName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentTitleColumnName() == null ? 0 : this.getDocumentTitleColumnName().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getChangeDetectingColumns() == null ? 0 : this.getChangeDetectingColumns().hashCode());
        return hashCode;
    }

    public ColumnConfiguration clone() {
        try {
            return (ColumnConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColumnConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

