/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsecuretunneling;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotsecuretunneling.AWSIoTSecureTunneling;
import com.amazonaws.services.iotsecuretunneling.AWSIoTSecureTunnelingClientBuilder;
import com.amazonaws.services.iotsecuretunneling.model.AWSIoTSecureTunnelingException;
import com.amazonaws.services.iotsecuretunneling.model.CloseTunnelRequest;
import com.amazonaws.services.iotsecuretunneling.model.CloseTunnelResult;
import com.amazonaws.services.iotsecuretunneling.model.DescribeTunnelRequest;
import com.amazonaws.services.iotsecuretunneling.model.DescribeTunnelResult;
import com.amazonaws.services.iotsecuretunneling.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotsecuretunneling.model.ListTagsForResourceResult;
import com.amazonaws.services.iotsecuretunneling.model.ListTunnelsRequest;
import com.amazonaws.services.iotsecuretunneling.model.ListTunnelsResult;
import com.amazonaws.services.iotsecuretunneling.model.OpenTunnelRequest;
import com.amazonaws.services.iotsecuretunneling.model.OpenTunnelResult;
import com.amazonaws.services.iotsecuretunneling.model.TagResourceRequest;
import com.amazonaws.services.iotsecuretunneling.model.TagResourceResult;
import com.amazonaws.services.iotsecuretunneling.model.UntagResourceRequest;
import com.amazonaws.services.iotsecuretunneling.model.UntagResourceResult;
import com.amazonaws.services.iotsecuretunneling.model.transform.CloseTunnelRequestProtocolMarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.CloseTunnelResultJsonUnmarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.DescribeTunnelRequestProtocolMarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.DescribeTunnelResultJsonUnmarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.ListTunnelsRequestProtocolMarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.ListTunnelsResultJsonUnmarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.OpenTunnelRequestProtocolMarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.OpenTunnelResultJsonUnmarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotsecuretunneling.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSIoTSecureTunnelingClient
extends AmazonWebServiceClient
implements AWSIoTSecureTunneling {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoTSecureTunneling.class);
    private static final String DEFAULT_SIGNING_NAME = "IoTSecuredTunneling";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller(LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSIoTSecureTunnelingException.class));

    public static AWSIoTSecureTunnelingClientBuilder builder() {
        return AWSIoTSecureTunnelingClientBuilder.standard();
    }

    AWSIoTSecureTunnelingClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSIoTSecureTunnelingClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("api.tunneling.iot");
        this.setEndpoint("api.tunneling.iot.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iotsecuretunneling/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iotsecuretunneling/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CloseTunnelResult closeTunnel(CloseTunnelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCloseTunnel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CloseTunnelResult executeCloseTunnel(CloseTunnelRequest closeTunnelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(closeTunnelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CloseTunnelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CloseTunnelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(closeTunnelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoTSecureTunneling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CloseTunnel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CloseTunnelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CloseTunnelResult closeTunnelResult = (CloseTunnelResult)response.getAwsResponse();
            return closeTunnelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTunnelResult describeTunnel(DescribeTunnelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeTunnel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTunnelResult executeDescribeTunnel(DescribeTunnelRequest describeTunnelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTunnelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTunnelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTunnelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeTunnelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoTSecureTunneling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeTunnel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTunnelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTunnelResult describeTunnelResult = (DescribeTunnelResult)response.getAwsResponse();
            return describeTunnelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoTSecureTunneling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTunnelsResult listTunnels(ListTunnelsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTunnels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTunnelsResult executeListTunnels(ListTunnelsRequest listTunnelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTunnelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTunnelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTunnelsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTunnelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoTSecureTunneling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTunnels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTunnelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTunnelsResult listTunnelsResult = (ListTunnelsResult)response.getAwsResponse();
            return listTunnelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public OpenTunnelResult openTunnel(OpenTunnelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeOpenTunnel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final OpenTunnelResult executeOpenTunnel(OpenTunnelRequest openTunnelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(openTunnelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<OpenTunnelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new OpenTunnelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(openTunnelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoTSecureTunneling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "OpenTunnel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new OpenTunnelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            OpenTunnelResult openTunnelResult = (OpenTunnelResult)response.getAwsResponse();
            return openTunnelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoTSecureTunneling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoTSecureTunneling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

