/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsecuretunneling;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotsecuretunneling.AWSIoTSecureTunnelingAsync;
import com.amazonaws.services.iotsecuretunneling.AWSIoTSecureTunnelingAsyncClientBuilder;
import com.amazonaws.services.iotsecuretunneling.AWSIoTSecureTunnelingClient;
import com.amazonaws.services.iotsecuretunneling.model.CloseTunnelRequest;
import com.amazonaws.services.iotsecuretunneling.model.CloseTunnelResult;
import com.amazonaws.services.iotsecuretunneling.model.DescribeTunnelRequest;
import com.amazonaws.services.iotsecuretunneling.model.DescribeTunnelResult;
import com.amazonaws.services.iotsecuretunneling.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotsecuretunneling.model.ListTagsForResourceResult;
import com.amazonaws.services.iotsecuretunneling.model.ListTunnelsRequest;
import com.amazonaws.services.iotsecuretunneling.model.ListTunnelsResult;
import com.amazonaws.services.iotsecuretunneling.model.OpenTunnelRequest;
import com.amazonaws.services.iotsecuretunneling.model.OpenTunnelResult;
import com.amazonaws.services.iotsecuretunneling.model.TagResourceRequest;
import com.amazonaws.services.iotsecuretunneling.model.TagResourceResult;
import com.amazonaws.services.iotsecuretunneling.model.UntagResourceRequest;
import com.amazonaws.services.iotsecuretunneling.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTSecureTunnelingAsyncClient
extends AWSIoTSecureTunnelingClient
implements AWSIoTSecureTunnelingAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTSecureTunnelingAsyncClientBuilder asyncBuilder() {
        return AWSIoTSecureTunnelingAsyncClientBuilder.standard();
    }

    AWSIoTSecureTunnelingAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CloseTunnelResult> closeTunnelAsync(CloseTunnelRequest request) {
        return this.closeTunnelAsync(request, null);
    }

    @Override
    public Future<CloseTunnelResult> closeTunnelAsync(CloseTunnelRequest request, final AsyncHandler<CloseTunnelRequest, CloseTunnelResult> asyncHandler) {
        final CloseTunnelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CloseTunnelResult>(){

            @Override
            public CloseTunnelResult call() throws Exception {
                CloseTunnelResult result = null;
                try {
                    result = AWSIoTSecureTunnelingAsyncClient.this.executeCloseTunnel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTunnelResult> describeTunnelAsync(DescribeTunnelRequest request) {
        return this.describeTunnelAsync(request, null);
    }

    @Override
    public Future<DescribeTunnelResult> describeTunnelAsync(DescribeTunnelRequest request, final AsyncHandler<DescribeTunnelRequest, DescribeTunnelResult> asyncHandler) {
        final DescribeTunnelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTunnelResult>(){

            @Override
            public DescribeTunnelResult call() throws Exception {
                DescribeTunnelResult result = null;
                try {
                    result = AWSIoTSecureTunnelingAsyncClient.this.executeDescribeTunnel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSIoTSecureTunnelingAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTunnelsResult> listTunnelsAsync(ListTunnelsRequest request) {
        return this.listTunnelsAsync(request, null);
    }

    @Override
    public Future<ListTunnelsResult> listTunnelsAsync(ListTunnelsRequest request, final AsyncHandler<ListTunnelsRequest, ListTunnelsResult> asyncHandler) {
        final ListTunnelsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTunnelsResult>(){

            @Override
            public ListTunnelsResult call() throws Exception {
                ListTunnelsResult result = null;
                try {
                    result = AWSIoTSecureTunnelingAsyncClient.this.executeListTunnels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<OpenTunnelResult> openTunnelAsync(OpenTunnelRequest request) {
        return this.openTunnelAsync(request, null);
    }

    @Override
    public Future<OpenTunnelResult> openTunnelAsync(OpenTunnelRequest request, final AsyncHandler<OpenTunnelRequest, OpenTunnelResult> asyncHandler) {
        final OpenTunnelRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<OpenTunnelResult>(){

            @Override
            public OpenTunnelResult call() throws Exception {
                OpenTunnelResult result = null;
                try {
                    result = AWSIoTSecureTunnelingAsyncClient.this.executeOpenTunnel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSIoTSecureTunnelingAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSIoTSecureTunnelingAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

