/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.TrainingDataSource;

@SdkInternalApi
public class TrainingDataSourceMarshaller {
    private static final MarshallingInfo<String> DATALOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataLocation").build();
    private static final MarshallingInfo<String> DATAACCESSROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataAccessRoleArn").build();
    private static final TrainingDataSourceMarshaller instance = new TrainingDataSourceMarshaller();

    public static TrainingDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(TrainingDataSource trainingDataSource, ProtocolMarshaller protocolMarshaller) {
        if (trainingDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(trainingDataSource.getDataLocation(), DATALOCATION_BINDING);
            protocolMarshaller.marshall(trainingDataSource.getDataAccessRoleArn(), DATAACCESSROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

