/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.ModelScores;
import java.util.Map;

@SdkInternalApi
public class ModelScoresMarshaller {
    private static final MarshallingInfo<StructuredPojo> MODELVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("modelVersion").build();
    private static final MarshallingInfo<Map> SCORES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scores").build();
    private static final ModelScoresMarshaller instance = new ModelScoresMarshaller();

    public static ModelScoresMarshaller getInstance() {
        return instance;
    }

    public void marshall(ModelScores modelScores, ProtocolMarshaller protocolMarshaller) {
        if (modelScores == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(modelScores.getModelVersion(), MODELVERSION_BINDING);
            protocolMarshaller.marshall(modelScores.getScores(), SCORES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

